/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.eureka;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import org.springframework.cloud.netflix.ribbon.eureka.ZoneUtils;

class DomainExtractingServer
extends DiscoveryEnabledServer {
    private String id;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DomainExtractingServer(DiscoveryEnabledServer server, boolean useSecurePort, boolean useIpAddr, boolean approximateZoneFromHostname) {
        super(server.getInstanceInfo(), useSecurePort, useIpAddr);
        if (server.getInstanceInfo().getMetadata().containsKey("zone")) {
            this.setZone((String)server.getInstanceInfo().getMetadata().get("zone"));
        } else if (approximateZoneFromHostname) {
            this.setZone(ZoneUtils.extractApproximateZone(server.getHost()));
        } else {
            this.setZone(server.getZone());
        }
        this.setId(this.extractId((Server)server));
        this.setAlive(server.isAlive());
        this.setReadyToServe(server.isReadyToServe());
    }

    private String extractId(Server server) {
        DiscoveryEnabledServer enabled;
        InstanceInfo instance;
        if (server instanceof DiscoveryEnabledServer && (instance = (enabled = (DiscoveryEnabledServer)server).getInstanceInfo()).getMetadata().containsKey("instanceId")) {
            return instance.getHostName() + ":" + (String)instance.getMetadata().get("instanceId");
        }
        return super.getId();
    }
}

