/*
 * Decompiled with CFR 0.152.
 */
package feign.okhttp;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public final class OkHttpClient
implements Client {
    private final okhttp3.OkHttpClient delegate;

    public OkHttpClient() {
        this(new okhttp3.OkHttpClient());
    }

    public OkHttpClient(okhttp3.OkHttpClient delegate) {
        this.delegate = delegate;
    }

    static okhttp3.Request toOkHttpRequest(Request input) {
        boolean isMethodWithBody;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(input.url());
        MediaType mediaType = null;
        boolean hasAcceptHeader = false;
        for (String field : input.headers().keySet()) {
            if (field.equalsIgnoreCase("Accept")) {
                hasAcceptHeader = true;
            }
            for (String value : (Collection)input.headers().get(field)) {
                requestBuilder.addHeader(field, value);
                if (!field.equalsIgnoreCase("Content-Type")) continue;
                mediaType = MediaType.parse((String)value);
                if (input.charset() == null) continue;
                mediaType.charset(input.charset());
            }
        }
        if (!hasAcceptHeader) {
            requestBuilder.addHeader("Accept", "*/*");
        }
        byte[] inputBody = input.body();
        boolean bl = isMethodWithBody = "POST".equals(input.method()) || "PUT".equals(input.method());
        if (isMethodWithBody) {
            requestBuilder.removeHeader("Content-Type");
            if (inputBody == null) {
                inputBody = new byte[]{};
            }
        }
        RequestBody body = inputBody != null ? RequestBody.create(mediaType, (byte[])inputBody) : null;
        requestBuilder.method(input.method(), body);
        return requestBuilder.build();
    }

    private static Response toFeignResponse(okhttp3.Response input) throws IOException {
        return Response.builder().status(input.code()).reason(input.message()).headers(OkHttpClient.toMap(input.headers())).body(OkHttpClient.toBody(input.body())).build();
    }

    private static Map<String, Collection<String>> toMap(Headers headers) {
        return headers.toMultimap();
    }

    private static Response.Body toBody(final ResponseBody input) throws IOException {
        if (input == null || input.contentLength() == 0L) {
            if (input != null) {
                input.close();
            }
            return null;
        }
        final Integer length = input.contentLength() >= 0L && input.contentLength() <= Integer.MAX_VALUE ? Integer.valueOf((int)input.contentLength()) : null;
        return new Response.Body(){

            public void close() throws IOException {
                input.close();
            }

            public Integer length() {
                return length;
            }

            public boolean isRepeatable() {
                return false;
            }

            public InputStream asInputStream() throws IOException {
                return input.byteStream();
            }

            public Reader asReader() throws IOException {
                return input.charStream();
            }
        };
    }

    public Response execute(Request input, Request.Options options) throws IOException {
        okhttp3.OkHttpClient requestScoped = this.delegate.connectTimeoutMillis() != options.connectTimeoutMillis() || this.delegate.readTimeoutMillis() != options.readTimeoutMillis() ? this.delegate.newBuilder().connectTimeout((long)options.connectTimeoutMillis(), TimeUnit.MILLISECONDS).readTimeout((long)options.readTimeoutMillis(), TimeUnit.MILLISECONDS).build() : this.delegate;
        okhttp3.Request request = OkHttpClient.toOkHttpRequest(input);
        okhttp3.Response response = requestScoped.newCall(request).execute();
        return OkHttpClient.toFeignResponse(response).toBuilder().request(input).build();
    }
}

