/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.volcengine.ApiCallback;
import com.volcengine.ApiException;
import com.volcengine.ApiResponse;
import com.volcengine.BaseClient;
import com.volcengine.JSON;
import com.volcengine.Pair;
import com.volcengine.ProgressRequestBody;
import com.volcengine.StringUtil;
import com.volcengine.auth.Authentication;
import com.volcengine.auth.CredentialProvider;
import com.volcengine.endpoint.DefaultEndpointProvider;
import com.volcengine.endpoint.EndpointResolver;
import com.volcengine.interceptor.BuildRequestInterceptor;
import com.volcengine.interceptor.DeserializedResponseInterceptor;
import com.volcengine.interceptor.HttpLoggingInterceptor;
import com.volcengine.interceptor.InitInterceptorContext;
import com.volcengine.interceptor.InterceptorChain;
import com.volcengine.interceptor.InterceptorContext;
import com.volcengine.interceptor.ResolveEndpointInterceptor;
import com.volcengine.interceptor.ResponseInterceptorContext;
import com.volcengine.interceptor.SignRequestInterceptor;
import com.volcengine.model.AbstractResponse;
import com.volcengine.model.ResponseMetadata;
import com.volcengine.observability.debugger.LogLevel;
import com.volcengine.observability.debugger.SdkConfigLog;
import com.volcengine.observability.debugger.SdkDebugLog;
import com.volcengine.retryer.BackoffStrategy;
import com.volcengine.retryer.DefaultRetryerSetting;
import com.volcengine.retryer.RetryCondition;
import com.volcengine.retryer.Retryer;
import com.volcengine.sign.Credentials;
import com.volcengine.sign.ServiceInfo;
import com.volcengine.sign.VolcstackSign;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.lang.StringUtils;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.format.DateTimeFormatter;

public class ApiClient
extends BaseClient {
    private static final String DefaultAuthentication = "volcengineSign";
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private DateFormat dateFormat;
    private DateFormat datetimeFormat;
    private boolean lenientDatetimeFormat;
    private int dateLength;
    private InputStream sslCaCert;
    private boolean verifyingSsl;
    private KeyManager[] keyManagers;
    private OkHttpClient httpClient;
    private JSON json;
    private com.squareup.okhttp.logging.HttpLoggingInterceptor loggingInterceptor;
    private Credentials credentials;
    private String region;
    private String endpoint;
    private boolean disableSSL = false;
    private InterceptorChain interceptorChain = new InterceptorChain();
    private EndpointResolver endpointResolver;
    private CredentialProvider credentialProvider;
    private Integer maxIdleConns = 5;
    private Integer keepAliveDurationMs = 300000;
    private Set<String> customBootstrapRegion;
    private Boolean useDualStack;
    private boolean autoRetry = true;
    private final Retryer retryer = DefaultRetryerSetting.DEFAULT_RETRYER;
    private String httpProxy;
    private String httpsProxy;
    private SdkConfigLog sdkConfigLog;

    public ApiClient() {
        ConnectionPool connectionPool = new ConnectionPool(this.maxIdleConns.intValue(), (long)this.keepAliveDurationMs.intValue());
        this.httpClient = new OkHttpClient();
        this.httpClient.setConnectionPool(connectionPool);
        this.httpClient.interceptors().add(new HttpLoggingInterceptor());
        this.verifyingSsl = true;
        this.json = new JSON();
        this.setUserAgent(ApiClient.getUserAgent());
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put(DefaultAuthentication, new VolcstackSign());
        this.authentications = Collections.unmodifiableMap(this.authentications);
        this.endpointResolver = new DefaultEndpointProvider();
        this.interceptorChain.appendRequestInterceptor(new ResolveEndpointInterceptor());
        this.interceptorChain.appendRequestInterceptor(new BuildRequestInterceptor());
        this.interceptorChain.appendRequestInterceptor(new SignRequestInterceptor());
        this.interceptorChain.appendResponseInterceptor(new DeserializedResponseInterceptor());
        this.updateClientProxy();
    }

    private static String getUserAgent() {
        String format = "%s/%s/(%s;%s;%s)";
        String osInfo = System.getProperty("os.name") + "-" + System.getProperty("os.version");
        String jdkInfo = "java-" + System.getProperty("java.version");
        String arch = System.getProperty("os.arch");
        return String.format(format, "volcengine-java-sdk", "0.2.43", jdkInfo, osInfo, arch);
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public ApiClient setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public boolean getDisableSSL() {
        return this.disableSSL;
    }

    public ApiClient setDisableSSL(boolean disableSSL) {
        this.disableSSL = disableSSL;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public ApiClient setRegion(String region) {
        this.region = region;
        Authentication authentication = this.getAuthentication(DefaultAuthentication);
        if (authentication instanceof VolcstackSign) {
            VolcstackSign volcengineSign = (VolcstackSign)authentication;
            volcengineSign.setRegion(region);
        }
        return this;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public ApiClient setCredentials(Credentials credentials) {
        this.credentials = credentials;
        Authentication authentication = this.getAuthentication(DefaultAuthentication);
        if (authentication instanceof VolcstackSign) {
            VolcstackSign volcengineSign = (VolcstackSign)authentication;
            volcengineSign.setCredentials(credentials);
        }
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public ApiClient setJSON(JSON json) {
        this.json = json;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ApiClient setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        this.applySslSettings();
        return this;
    }

    public InputStream getSslCaCert() {
        return this.sslCaCert;
    }

    public ApiClient setSslCaCert(InputStream sslCaCert) {
        this.sslCaCert = sslCaCert;
        this.applySslSettings();
        return this;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public ApiClient setKeyManagers(KeyManager[] managers) {
        this.keyManagers = managers;
        this.applySslSettings();
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        this.json.setOffsetDateTimeFormat(dateFormat);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateFormat) {
        this.json.setLocalDateFormat(dateFormat);
        return this;
    }

    public ApiClient setLenientOnJson(boolean lenientOnJson) {
        this.json.setLenientOnJson(lenientOnJson);
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        this.debugging = debugging;
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient.setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public int getReadTimeout() {
        return this.httpClient.getReadTimeout();
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.httpClient.setReadTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public int getWriteTimeout() {
        return this.httpClient.getWriteTimeout();
    }

    public ApiClient setWriteTimeout(int writeTimeout) {
        this.httpClient.setWriteTimeout((long)writeTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public Set<String> getCustomBootstrapRegion() {
        return this.customBootstrapRegion;
    }

    public ApiClient setCustomBootstrapRegion(Set<String> customBootstrapRegion) {
        this.customBootstrapRegion = customBootstrapRegion;
        return this;
    }

    public Boolean getUseDualStack() {
        return this.useDualStack;
    }

    public ApiClient setUseDualStack(boolean useDualStack) {
        this.useDualStack = useDualStack;
        return this;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public ApiClient setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        this.updateClientProxy();
        return this;
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public ApiClient setHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        this.updateClientProxy();
        return this;
    }

    private void updateClientProxy() {
        this.httpClient.setProxySelector(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                ArrayList<Proxy> proxies = new ArrayList<Proxy>();
                if (ApiClient.this.disableSSL) {
                    ApiClient.this.addProxy(proxies, ApiClient.this.httpProxy, "HTTP_PROXY");
                } else {
                    ApiClient.this.addProxy(proxies, ApiClient.this.httpsProxy, "HTTPS_PROXY");
                }
                return proxies;
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        });
    }

    private void addProxy(List<Proxy> proxies, String proxy, String env) {
        if (!StringUtils.isEmpty((String)proxy)) {
            try {
                URI u = new URI(proxy);
                proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(u.getHost(), u.getPort())));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (!StringUtils.isEmpty((String)env)) {
            String envProxy = System.getenv(env.toUpperCase());
            if (StringUtils.isEmpty((String)envProxy)) {
                envProxy = System.getenv(env.toLowerCase());
            }
            if (!StringUtils.isEmpty((String)envProxy)) {
                try {
                    URI u = new URI(envProxy);
                    proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(u.getHost(), u.getPort())));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = this.json.serialize(param);
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPair(String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value instanceof Collection) {
            return params;
        }
        params.add(new Pair(name, this.parameterToString(value)));
        return params;
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Collection value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null || value.isEmpty()) {
            return params;
        }
        if ("multi".equals(collectionFormat)) {
            for (Object item : value) {
                params.add(new Pair(name, this.escapeString(this.parameterToString(item))));
            }
            return params;
        }
        String delimiter = ",";
        if ("ssv".equals(collectionFormat)) {
            delimiter = this.escapeString(" ");
        } else if ("tsv".equals(collectionFormat)) {
            delimiter = this.escapeString("\t");
        } else if ("pipes".equals(collectionFormat)) {
            delimiter = this.escapeString("|");
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : value) {
            sb.append(delimiter);
            sb.append(this.escapeString(this.parameterToString(item)));
        }
        params.add(new Pair(name, sb.substring(delimiter.length())));
        return params;
    }

    public String sanitizeFilename(String filename) {
        return filename.replaceAll(".*[/\\\\]", "");
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0 || contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public <T> T deserialize(Response response, Type returnType, boolean ... isCommon) throws ApiException {
        String contentType;
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        if (returnType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        HashMap<String, ResponseMetadata> meta = new HashMap<String, ResponseMetadata>();
        if (isCommon.length == 0 || !isCommon[0]) {
            if (!this.convertResponseBody(respBody, builder, meta)) {
                throw new ApiException(response.code(), response.headers().toMultimap(), respBody, (ResponseMetadata)meta.get("ResponseMetadata"));
            }
            respBody = builder.toString();
        }
        if ((contentType = response.headers().get("Content-Type")) == null) {
            contentType = "application/json";
        }
        if (this.isJsonMime(contentType)) {
            Object t = this.json.deserialize(respBody, returnType);
            if (t instanceof AbstractResponse) {
                try {
                    Method m = t.getClass().getMethod("setResponseMetadata", ResponseMetadata.class);
                    m.invoke(t, meta.get("ResponseMetadata"));
                }
                catch (Exception e) {
                    throw new ApiException(e.getMessage(), response.code(), response.headers().toMultimap(), respBody, (ResponseMetadata)meta.get("ResponseMetadata"));
                }
            }
            return t;
        }
        if (returnType.equals(String.class)) {
            return (T)respBody;
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), response.headers().toMultimap(), respBody, (ResponseMetadata)meta.get("ResponseMetadata"));
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if (obj instanceof byte[]) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])((byte[])obj));
        }
        if (obj instanceof File) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)((File)obj));
        }
        if (this.isJsonMime(contentType)) {
            String content = obj != null ? this.json.serialize(obj) : null;
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content);
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported");
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
            sink.writeAll((Source)response.body().source());
            sink.close();
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = response.header("Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = this.sanitizeFilename(matcher.group(1));
        }
        String prefix = null;
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(".");
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(Paths.get(this.tempFolderPath, new String[0]), prefix, suffix, new FileAttribute[0]).toFile();
    }

    public <T> ApiResponse<T> execute(Call call) throws ApiException {
        return this.execute(call, null, new boolean[0]);
    }

    public <T> ApiResponse<T> execute(Call call, Type returnType, boolean ... isCommon) throws ApiException {
        if (!(call instanceof InterceptorContext)) {
            throw new ApiException("not support custom context class");
        }
        InterceptorContext context = (InterceptorContext)call;
        ResponseInterceptorContext responseInterceptorContext = new ResponseInterceptorContext();
        responseInterceptorContext.setCommon(isCommon.length > 0 && isCommon[0]);
        responseInterceptorContext.setReturnType(returnType);
        context.setResponseContext(responseInterceptorContext);
        context.setApiClient(this);
        this.logSdkConfig();
        int numMaxRetries = this.retryer.getNumMaxRetries();
        ApiResponse<Object> apiResponse = null;
        for (int retryCount = 0; retryCount <= numMaxRetries; ++retryCount) {
            ApiException apiException = null;
            apiResponse = null;
            this.interceptorChain.executeRequest(context);
            try {
                Call finalCall = context.getApiClient().getHttpClient().newCall(context.getRequestContext().getRequest());
                Response response = finalCall.execute();
                context.getResponseContext().setOriginalResponse(response);
                this.interceptorChain.executeResponse(context);
                apiResponse = new ApiResponse<Object>(response.code(), response.headers().toMultimap(), context.getResponseContext().getData());
            }
            catch (IOException e) {
                apiException = new ApiException(e);
            }
            catch (ApiException e) {
                apiException = this.handleApiResponseException(e);
            }
            if (this.requestShouldRetry(apiResponse, retryCount, apiException)) continue;
            if (apiException != null) {
                throw apiException;
            }
            return apiResponse;
        }
        return apiResponse;
    }

    private ApiException handleApiResponseException(ApiException apiException) {
        if (apiException.getResponseBody() != null) {
            StringBuilder builder = new StringBuilder();
            HashMap<String, ResponseMetadata> meta = new HashMap<String, ResponseMetadata>();
            try {
                if (!this.convertResponseBody(apiException.getResponseBody(), builder, meta)) {
                    apiException.setResponseMetadata((ResponseMetadata)meta.get("ResponseMetadata"));
                }
            }
            catch (Exception e) {
                return apiException;
            }
        }
        return apiException;
    }

    private boolean requestShouldRetry(ApiResponse apiResponse, int retryCount, ApiException lastException) throws ApiException {
        if (this.autoRetry && this.retryer.shouldRetry(apiResponse, retryCount, lastException)) {
            SdkDebugLog.SDK_CORE_LOGGER.debugRetry("maxReryCout:{}, currentRetryCount:{}, backoffStrategy:{}", this.retryer.getNumMaxRetries(), retryCount + 1, this.retryer.getBackoffStrategy().getClass().getSimpleName());
            try {
                long delay = this.retryer.getBackoffDelay(retryCount);
                Thread.sleep(delay);
            }
            catch (Exception e) {
                SdkDebugLog.SDK_CORE_LOGGER.error(() -> "Failed to getBackoffDelay or sleep", e);
                throw new ApiException(e);
            }
            return true;
        }
        return false;
    }

    public <T> void executeAsync(Call call, ApiCallback<T> callback) {
        this.executeAsync(call, null, callback);
    }

    public <T> void executeAsync(Call call, Type returnType, ApiCallback<T> callback) {
        if (!(call instanceof InterceptorContext)) {
            callback.onFailure(new ApiException("not support custom context class"), 0, null);
            return;
        }
        InterceptorContext context = (InterceptorContext)call;
        ResponseInterceptorContext responseInterceptorContext = new ResponseInterceptorContext();
        responseInterceptorContext.setReturnType(returnType);
        context.setResponseContext(responseInterceptorContext);
        context.setApiClient(this);
        this.logSdkConfig();
        int maxRetries = this.retryer.getNumMaxRetries();
        AtomicInteger retryCount = new AtomicInteger(0);
        this.attemptAsync(context, callback, retryCount, maxRetries);
    }

    private <T> void attemptAsync(final InterceptorContext context, final ApiCallback<T> callback, final AtomicInteger retryCount, final int maxRetries) {
        try {
            this.interceptorChain.executeRequest(context);
        }
        catch (ApiException e) {
            callback.onFailure(e, 0, null);
            return;
        }
        Call okhttpCall = this.getHttpClient().newCall(context.getRequestContext().getRequest());
        okhttpCall.enqueue(new Callback(){

            public void onFailure(Request req, IOException ioe) {
                int current = retryCount.get();
                ApiException apiException = new ApiException(ioe);
                try {
                    if (ApiClient.this.autoRetry && current < maxRetries && ApiClient.this.requestShouldRetry(null, current, apiException)) {
                        retryCount.incrementAndGet();
                        ApiClient.this.attemptAsync(context, callback, retryCount, maxRetries);
                    } else {
                        callback.onFailure(apiException, 0, null);
                    }
                }
                catch (ApiException e) {
                    callback.onFailure(apiException, 0, null);
                }
            }

            public void onResponse(Response response) throws IOException {
                Object result = null;
                ApiException apiException = null;
                ApiResponse<Object> apiResponse = null;
                int current = retryCount.getAndIncrement();
                try {
                    context.getResponseContext().setOriginalResponse(response);
                    context.getApiClient().interceptorChain.executeResponse(context);
                    result = context.responseContext.getData();
                    apiResponse = new ApiResponse<Object>(response.code(), response.headers().toMultimap(), result);
                }
                catch (ApiException e) {
                    apiException = ApiClient.this.handleApiResponseException(e);
                }
                try {
                    if (!ApiClient.this.requestShouldRetry(apiResponse, current, apiException)) {
                        if (apiException != null) {
                            callback.onFailure(apiException, response.code(), response.headers().toMultimap());
                        } else {
                            callback.onSuccess(result, response.code(), response.headers().toMultimap());
                        }
                    } else {
                        ApiClient.this.attemptAsync(context, callback, retryCount, maxRetries);
                    }
                }
                catch (ApiException e) {
                    callback.onFailure(apiException, response.code(), response.headers().toMultimap());
                }
            }
        });
    }

    public <T> T handleResponse(Response response, Type returnType, boolean ... isCommon) throws ApiException {
        if (response.isSuccessful()) {
            if (returnType == null || response.code() == 204) {
                if (response.body() != null) {
                    try {
                        response.body().close();
                    }
                    catch (IOException e) {
                        throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                    }
                }
                return null;
            }
            return this.deserialize(response, returnType, isCommon);
        }
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
            }
            catch (IOException e) {
                throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    @Override
    public InterceptorContext buildCall(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener, boolean ... isCommon) throws ApiException {
        InterceptorContext interceptorContext = new InterceptorContext(this.httpClient, null);
        InitInterceptorContext requestInterceptorContext = new InitInterceptorContext.Builder().path(path).method(method).queryParams(queryParams).collectionQueryParams(collectionQueryParams).body(body).headerParams(headerParams).formParams(formParams).authNames(authNames).progressRequestListener(progressRequestListener).isCommon(isCommon.length > 0 && isCommon[0]).build();
        interceptorContext.setInitInterceptorContext(requestInterceptorContext);
        interceptorContext.setApiClient(this);
        return interceptorContext;
    }

    public void getDefaultContentType(Map<String, String> headerParams) {
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            headerParams.put("Content-Type", "text/plain");
        }
    }

    public boolean isApplicationJsonBody(Map<String, String> headerParams) {
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            return false;
        }
        return contentType.equals("application/json");
    }

    public boolean isPostBody(Map<String, String> headerParams) {
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            return false;
        }
        return contentType.equals("application/x-www-form-urlencoded");
    }

    public void updateQueryParams(List<Pair> queryParams, String[] param) {
        queryParams.add(new Pair("Action", param[1]));
        queryParams.add(new Pair("Version", param[2]));
    }

    public ServiceInfo addPairAndGetServiceInfo(String path, List<Pair> queryParams, Map<String, String> headerParams) {
        String[] param = path.split("/");
        if (param.length >= 6) {
            headerParams.put("Content-Type", param[5].replaceAll("_", "/"));
        }
        if (!this.isApplicationJsonBody(headerParams) && !this.isPostBody(headerParams)) {
            this.updateQueryParams(queryParams, param);
        }
        return new ServiceInfo(param[3], param[4]);
    }

    public String getTruePath(String path, Map<String, String> headerParams) {
        if (this.isApplicationJsonBody(headerParams) || this.isPostBody(headerParams)) {
            String[] param = path.split("/");
            return "/?Action=" + param[1] + "&Version=" + param[2];
        }
        return "/";
    }

    private boolean convertResponseBody(String source, StringBuilder stringBuilder, Map<String, ResponseMetadata> m) {
        Type t = new TypeToken<Map<String, ?>>(){}.getType();
        Map temp = (Map)this.json.deserialize(source, t);
        if (temp.containsKey("ResponseMetadata")) {
            ResponseMetadata meta = (ResponseMetadata)this.json.deserialize(this.json.serialize(temp.get("ResponseMetadata")), new TypeToken<ResponseMetadata>(){}.getType());
            m.put("ResponseMetadata", meta);
            if (meta.getError() != null) {
                return false;
            }
            if (temp.containsKey("Result")) {
                stringBuilder.append(this.json.serialize(temp.get("Result")));
            } else {
                stringBuilder.append(this.json.serialize(new HashMap()));
            }
            return true;
        }
        return false;
    }

    public void buildSimpleRequest(Object body, List<Pair> queryParams, Map<String, String> headerParams, StringBuilder builder, FormEncodingBuilder formBuilder, String chain, boolean ... isCommon) throws Exception {
        if (body == null) {
            return;
        }
        if (this.isApplicationJsonBody(headerParams)) {
            builder.append(this.json.serialize(body));
            return;
        }
        Class<?> clazz = body.getClass();
        if (isCommon.length > 0 && isCommon[0]) {
            try {
                Map map = (Map)body;
                if (this.isPostBody(headerParams)) {
                    for (Map.Entry entry : map.entrySet()) {
                        formBuilder.add((String)entry.getKey(), entry.getValue().toString());
                    }
                } else {
                    for (Map.Entry entry : map.entrySet()) {
                        Pair pair = new Pair((String)entry.getKey(), entry.getValue().toString());
                        queryParams.add(pair);
                    }
                }
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        if (!clazz.getName().startsWith("com.volcengine")) {
            if (this.isPostBody(headerParams)) {
                formBuilder.add(chain, body.toString());
            } else {
                Pair pair = new Pair(chain, body.toString());
                queryParams.add(pair);
            }
            return;
        }
        if (!chain.equals("")) {
            chain = chain + ".";
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(SerializedName.class) == null) continue;
            field.setAccessible(true);
            Object value = field.get(body);
            if (value == null) continue;
            if (value instanceof List) {
                int count = 0;
                for (Object o : (List)value) {
                    String key = chain + this.getMethodName(field.getName()) + "." + ++count;
                    this.buildSimpleRequest(o, queryParams, headerParams, builder, formBuilder, key, new boolean[0]);
                }
                continue;
            }
            if (!field.getType().getName().startsWith("com.volcengine")) {
                this.buildBodyOrParameter(field, value, queryParams, headerParams, builder, formBuilder, chain);
                continue;
            }
            if (field.getType().isEnum()) {
                try {
                    Method method = field.getType().getDeclaredMethod("getValue", new Class[0]);
                    Object v = method.invoke(value, new Object[0]);
                    if (v == null) continue;
                    this.buildBodyOrParameter(field, v, queryParams, headerParams, builder, formBuilder, chain);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new ApiException("sdk internal error,please contract us in github,ErrorCode is EnumNotGetValueMethod");
                }
            }
            String key = chain + this.getMethodName(field.getName());
            this.buildSimpleRequest(value, queryParams, headerParams, builder, formBuilder, key, new boolean[0]);
        }
    }

    private void buildBodyOrParameter(Field field, Object v, List<Pair> queryParams, Map<String, String> headerParams, StringBuilder builder, FormEncodingBuilder formBuilder, String chain) throws Exception {
        SerializedName s;
        String defaultName = this.getMethodName(field.getName());
        String name = field.getAnnotation(SerializedName.class) != null ? (!(s = field.getAnnotation(SerializedName.class)).value().equals(defaultName) ? s.value() : defaultName) : defaultName;
        if (this.isPostBody(headerParams)) {
            formBuilder.add(chain + name, v.toString());
        } else {
            Pair pair = new Pair(chain + name, v.toString());
            queryParams.add(pair);
        }
    }

    private String getMethodName(String fieldName) throws Exception {
        char[] chars = fieldName.toCharArray();
        chars[0] = this.toUpperCase(chars[0]);
        return String.valueOf(chars);
    }

    private char toUpperCase(char c) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c ^ 0x20);
        }
        return c;
    }

    public Request buildRequest(String path, String method, List<Pair> queryParams, List<Pair> collectionQueryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener, boolean ... isCommon) throws ApiException {
        Object reqBody;
        this.getDefaultContentType(headerParams);
        ServiceInfo serviceInfo = this.addPairAndGetServiceInfo(path, queryParams, headerParams);
        method = serviceInfo.getMethod().toUpperCase();
        String truePath = this.getTruePath(path, headerParams);
        String contentType = headerParams.get("Content-Type");
        StringBuilder bodyBuilder = new StringBuilder();
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        try {
            this.buildSimpleRequest(body, queryParams, headerParams, bodyBuilder, formBuilder, "", isCommon);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        String url = this.buildUrl(truePath, queryParams, collectionQueryParams);
        Request.Builder reqBuilder = new Request.Builder().url(url);
        if (!HttpMethod.permitsRequestBody((String)method)) {
            reqBody = null;
        } else if ("application/x-www-form-urlencoded".equals(contentType)) {
            reqBody = formBuilder.build();
            queryParams.clear();
            this.updateQueryParams(queryParams, path.split("/"));
        } else if ("multipart/form-data".equals(contentType)) {
            reqBody = this.buildRequestBodyMultipart(formParams);
            queryParams.clear();
            this.updateQueryParams(queryParams, path.split("/"));
        } else if (body == null) {
            reqBody = "DELETE".equals(method) ? null : RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)"");
            queryParams.clear();
            this.updateQueryParams(queryParams, path.split("/"));
        } else {
            reqBody = this.serialize(body, contentType);
            queryParams.clear();
            this.updateQueryParams(queryParams, path.split("/"));
        }
        Buffer buffer = new Buffer();
        try {
            if (reqBody != null) {
                reqBody.writeTo((BufferedSink)buffer);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        this.updateParamsForAuth(authNames, queryParams, headerParams, serviceInfo, buffer.readUtf8());
        this.processHeaderParams(headerParams, reqBuilder);
        Request request = null;
        if (progressRequestListener != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody((RequestBody)reqBody, progressRequestListener);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        return request;
    }

    public String buildUrl(String path, List<Pair> queryParams, List<Pair> collectionQueryParams) {
        String value;
        String prefix;
        StringBuilder url = new StringBuilder();
        if (this.disableSSL) {
            url.append("http://");
        } else {
            url.append("https://");
        }
        url.append(this.endpoint).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        if (collectionQueryParams != null && !collectionQueryParams.isEmpty()) {
            prefix = url.toString().contains("?") ? "&" : "?";
            for (Pair param : collectionQueryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(value);
            }
        }
        return url.toString();
    }

    public void buildQueryParams(String path, StringBuilder url, List<Pair> queryParams) {
        if (queryParams != null && !queryParams.isEmpty()) {
            String prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public void processDefaultHeader(Map<String, String> headerParams) {
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            headerParams.put(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams, "");
        }
    }

    public void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams, ServiceInfo serviceInfo, String payload) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            if (auth instanceof VolcstackSign) {
                VolcstackSign volcengineSign = (VolcstackSign)auth;
                if (volcengineSign.getCredentials() == null) {
                    throw new RuntimeException("Credentials must set when ApiClient init");
                }
                if (StringUtils.isEmpty((String)this.credentials.getAccessKey()) || StringUtils.isEmpty((String)this.credentials.getSecretKey())) {
                    throw new RuntimeException("AccessKey and SecretKey must set when ApiClient init Credentials");
                }
                if (StringUtils.isEmpty((String)volcengineSign.getRegion())) {
                    throw new RuntimeException("Region must set when ApiClient init");
                }
                VolcstackSign requestSign = volcengineSign.copy();
                requestSign.setMethod(serviceInfo.getMethod().toUpperCase());
                requestSign.setService(serviceInfo.getServiceName());
                auth = requestSign;
            }
            auth.applyToParams(queryParams, headerParams, payload);
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBuilder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBuilder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> formParams) {
        MultipartBuilder mpBuilder = new MultipartBuilder().type(MultipartBuilder.FORM);
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            if (param.getValue() instanceof File) {
                File file = (File)param.getValue();
                Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + file.getName() + "\""});
                MediaType mediaType = MediaType.parse((String)this.guessContentTypeFromFile(file));
                mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)mediaType, (File)file));
                continue;
            }
            Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\""});
            mpBuilder.addPart(partHeaders, RequestBody.create(null, (String)this.parameterToString(param.getValue())));
        }
        return mpBuilder.build();
    }

    public String guessContentTypeFromFile(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    private void applySslSettings() {
        try {
            TrustManager[] trustManagers = null;
            HostnameVerifier hostnameVerifier = null;
            if (!this.verifyingSsl) {
                X509TrustManager trustAll = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                SSLContext sslContext = SSLContext.getInstance("TLS");
                trustManagers = new TrustManager[]{trustAll};
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
            } else if (this.sslCaCert != null) {
                char[] password = null;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(this.sslCaCert);
                if (certificates.isEmpty()) {
                    throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                }
                KeyStore caKeyStore = this.newEmptyKeyStore(password);
                int index = 0;
                for (Certificate certificate : certificates) {
                    String certificateAlias = "ca" + Integer.toString(index++);
                    caKeyStore.setCertificateEntry(certificateAlias, certificate);
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(caKeyStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            if (this.keyManagers != null || trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(this.keyManagers, trustManagers, new SecureRandom());
                this.httpClient.setSslSocketFactory(sslContext.getSocketFactory());
            } else {
                this.httpClient.setSslSocketFactory(null);
            }
            this.httpClient.setHostnameVerifier(hostnameVerifier);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public CredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public ApiClient setCredentialProvider(CredentialProvider credentialProvider) {
        this.credentialProvider = credentialProvider;
        return this;
    }

    public EndpointResolver getEndpointResolver() {
        return this.endpointResolver;
    }

    public ApiClient setEndpointResolver(EndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
        return this;
    }

    public Integer getMaxIdleConns() {
        return this.maxIdleConns;
    }

    public ApiClient setMaxIdleConns(Integer maxIdleConns) {
        this.maxIdleConns = maxIdleConns;
        this.httpClient.setConnectionPool(new ConnectionPool(maxIdleConns.intValue(), (long)this.keepAliveDurationMs.intValue()));
        return this;
    }

    public Integer getKeepAliveDurationMs() {
        return this.keepAliveDurationMs;
    }

    public ApiClient setKeepAliveDurationMs(Integer keepAliveDurationMs) {
        this.keepAliveDurationMs = keepAliveDurationMs;
        this.httpClient.setConnectionPool(new ConnectionPool(this.maxIdleConns.intValue(), (long)keepAliveDurationMs.intValue()));
        return this;
    }

    public boolean isAutoRetry() {
        return this.autoRetry;
    }

    public ApiClient setAutoRetry(boolean autoRetry) {
        this.autoRetry = autoRetry;
        return this;
    }

    public int getNumMaxRetries() {
        return this.retryer.getNumMaxRetries();
    }

    public ApiClient setNumMaxRetries(int numMaxRetries) {
        this.retryer.setNumMaxRetries(numMaxRetries);
        return this;
    }

    public Set<String> getRetryErrorCodes() {
        return this.retryer.getRetryCondition().getRetryErrorCodes();
    }

    public ApiClient addRetryErrorCode(String retryErrorCode) {
        this.retryer.getRetryCondition().addRetryErrorCode(retryErrorCode);
        return this;
    }

    public ApiClient addRetryErrorCodes(Set<String> retryErrorCodes) {
        this.retryer.getRetryCondition().addRetryErrorCodes(retryErrorCodes);
        return this;
    }

    public long getMinRetryDelayMs() {
        return this.retryer.getBackoffStrategy().getMinRetryDelayMs();
    }

    public ApiClient setMinRetryDelayMs(long minRetryDelayMs) {
        this.retryer.getBackoffStrategy().setMinRetryDelayMs(minRetryDelayMs);
        return this;
    }

    public long getMaxRetryDelayMs() {
        return this.retryer.getBackoffStrategy().getMaxRetryDelayMs();
    }

    public ApiClient setMaxRetryDelayMs(long maxRetryDelayMs) {
        this.retryer.getBackoffStrategy().setMaxRetryDelayMs(maxRetryDelayMs);
        return this;
    }

    public RetryCondition getRetryCondition() {
        return this.retryer.getRetryCondition();
    }

    public ApiClient setRetryCondition(RetryCondition retryCondition) throws ApiException {
        Set<String> retryErrorCodes = this.retryer.getRetryCondition().getRetryErrorCodes();
        retryCondition.addRetryErrorCodes(retryErrorCodes);
        this.retryer.setRetryCondition(retryCondition);
        return this;
    }

    public BackoffStrategy getBackoffStrategy() {
        return this.retryer.getBackoffStrategy();
    }

    public ApiClient setBackoffStrategy(BackoffStrategy backoffStrategy) throws ApiException {
        long minRetryDelayMs = this.retryer.getBackoffStrategy().getMinRetryDelayMs();
        long maxRetryDelayMs = this.retryer.getBackoffStrategy().getMaxRetryDelayMs();
        backoffStrategy.setMinRetryDelayMs(minRetryDelayMs);
        backoffStrategy.setMaxRetryDelayMs(maxRetryDelayMs);
        this.retryer.setBackoffStrategy(backoffStrategy);
        return this;
    }

    @Override
    public OkHttpClient getOkHttpClient() {
        return this.httpClient;
    }

    public ApiClient setLogLevel(long logLevel) {
        SdkDebugLog.SDK_CORE_LOGGER.setLogLevel(logLevel);
        return this;
    }

    public long getLogLevel() {
        return SdkDebugLog.SDK_CORE_LOGGER.getLogLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSdkConfig() {
        if (!SdkDebugLog.SDK_CORE_LOGGER.isDebugEnabled() || !SdkDebugLog.SDK_CORE_LOGGER.matches(LogLevel.LOG_DEBUG_WITH_CONFIG)) {
            return;
        }
        if (this.sdkConfigLog != null) {
            this.sdkConfigLog.log();
        }
        ApiClient apiClient = this;
        synchronized (apiClient) {
            if (this.sdkConfigLog != null) {
                this.sdkConfigLog.log();
            }
            SdkConfigLog sdkConfigLog = new SdkConfigLog();
            sdkConfigLog.setMaxIdleConns(this.maxIdleConns);
            sdkConfigLog.setKeepAliveDurationMs(this.keepAliveDurationMs.intValue());
            sdkConfigLog.setDisableSSL(this.disableSSL);
            sdkConfigLog.setVerifyingSsl(this.verifyingSsl);
            sdkConfigLog.setHttpProxy(this.httpProxy);
            sdkConfigLog.setHttpsProxy(this.httpsProxy);
            sdkConfigLog.setConnectTimeout(this.getConnectTimeout());
            sdkConfigLog.setReadTimeout(this.getReadTimeout());
            sdkConfigLog.setWriteTimeout(this.getWriteTimeout());
            sdkConfigLog.setAutoRetry(this.autoRetry);
            sdkConfigLog.setMinRetryDelayMs(this.getMinRetryDelayMs());
            sdkConfigLog.setMaxRetryDelayMs(this.getMaxRetryDelayMs());
            sdkConfigLog.setRetryCondition(this.getRetryCondition());
            sdkConfigLog.setBackoffStrategy(this.getBackoffStrategy());
            sdkConfigLog.setRetryErrorCode(this.getRetryErrorCodes());
            sdkConfigLog.setRegion(this.region);
            sdkConfigLog.setEndpoint(this.endpoint);
            sdkConfigLog.setUseDualStack(this.useDualStack);
            sdkConfigLog.setCustomBootstrapRegion(this.customBootstrapRegion);
            sdkConfigLog.setEndpointResolver(this.endpointResolver);
            sdkConfigLog.log();
            this.sdkConfigLog = sdkConfigLog;
        }
    }
}

