/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.observability.debugger;

import com.volcengine.endpoint.EndpointResolver;
import com.volcengine.observability.debugger.SdkDebugLog;
import com.volcengine.retryer.BackoffStrategy;
import com.volcengine.retryer.RetryCondition;
import com.volcengine.utils.ConstantsUtil;
import java.util.Set;

public class SdkConfigLog {
    private String logBuffer = "";
    private String sdkVersion = "0.2.53";
    private int maxIdleConns;
    private long keepAliveDurationMs;
    private boolean disableSSL;
    private boolean verifyingSsl;
    private String httpProxy;
    private String httpsProxy;
    private int connectTimeout;
    private int readTimeout;
    private int writeTimeout;
    private boolean autoRetry;
    private long minRetryDelayMs;
    private long maxRetryDelayMs;
    private RetryCondition retryCondition;
    private BackoffStrategy backoffStrategy;
    private Set<String> retryErrorCode;
    private String region;
    private String endpoint;
    private Boolean useDualStack;
    private Set<String> customBootstrapRegion;
    private EndpointResolver endpointResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log() {
        if (this.logBuffer != null && !this.logBuffer.isEmpty()) {
            SdkDebugLog.SDK_CORE_LOGGER.debugConfig(this.logBuffer, new Object[0]);
            return;
        }
        SdkConfigLog sdkConfigLog = this;
        synchronized (sdkConfigLog) {
            if (this.logBuffer != null && !this.logBuffer.isEmpty()) {
                SdkDebugLog.SDK_CORE_LOGGER.debugConfig(this.logBuffer, new Object[0]);
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("========================= SDK CONFIGURATION =========================").append(ConstantsUtil.NEW_LINE);
            sb.append("SDK Version        : ").append(this.sdkVersion).append(ConstantsUtil.NEW_LINE);
            sb.append("[Connection Pool]").append(ConstantsUtil.NEW_LINE);
            sb.append("  Max Idle Conns   : ").append(this.maxIdleConns).append(ConstantsUtil.NEW_LINE);
            sb.append("  KeepAlive (ms)   : ").append(this.keepAliveDurationMs).append(ConstantsUtil.NEW_LINE);
            sb.append("[SSL]").append(ConstantsUtil.NEW_LINE);
            sb.append("  Disable SSL      : ").append(this.disableSSL).append(ConstantsUtil.NEW_LINE);
            sb.append("  Verifying SSL    : ").append(this.verifyingSsl).append(ConstantsUtil.NEW_LINE);
            sb.append("[Proxy]").append(ConstantsUtil.NEW_LINE);
            sb.append("  HTTP Proxy       : ").append(this.httpProxy).append(ConstantsUtil.NEW_LINE);
            sb.append("  HTTPS Proxy      : ").append(this.httpsProxy).append(ConstantsUtil.NEW_LINE);
            sb.append("[Timeout]").append(ConstantsUtil.NEW_LINE);
            sb.append("  Connect Timeout(ms)  : ").append(this.connectTimeout).append(ConstantsUtil.NEW_LINE);
            sb.append("  Read Timeout(ms)     : ").append(this.readTimeout).append(ConstantsUtil.NEW_LINE);
            sb.append("  Write Timeout(ms)    : ").append(this.writeTimeout).append(ConstantsUtil.NEW_LINE);
            sb.append("[Retry]").append(ConstantsUtil.NEW_LINE);
            sb.append("  Auto Retry       : ").append(this.autoRetry).append(ConstantsUtil.NEW_LINE);
            sb.append("  Min Delay (ms)   : ").append(this.minRetryDelayMs).append(ConstantsUtil.NEW_LINE);
            sb.append("  Max Delay (ms)   : ").append(this.maxRetryDelayMs).append(ConstantsUtil.NEW_LINE);
            sb.append("  Retry Condition  : ").append(this.retryCondition != null ? this.retryCondition.getClass().getSimpleName() : "null").append(ConstantsUtil.NEW_LINE);
            sb.append("  Backoff Strategy : ").append(this.backoffStrategy != null ? this.backoffStrategy.getClass().getSimpleName() : "null").append(ConstantsUtil.NEW_LINE);
            sb.append("  Retry ErrorCodes : ").append(this.retryErrorCode).append(ConstantsUtil.NEW_LINE);
            sb.append("[Endpoint Resolver]").append(ConstantsUtil.NEW_LINE);
            sb.append("  Region           : ").append(this.region).append(ConstantsUtil.NEW_LINE);
            sb.append("  Endpoint         : ").append(this.endpoint).append(ConstantsUtil.NEW_LINE);
            sb.append("  Use DualStack    : ").append(this.useDualStack).append(ConstantsUtil.NEW_LINE);
            sb.append("  Bootstrap Region : ").append(this.customBootstrapRegion).append(ConstantsUtil.NEW_LINE);
            sb.append("  Resolver Class   : ").append(this.endpointResolver != null ? this.endpointResolver.getClass().getSimpleName() : "null").append(ConstantsUtil.NEW_LINE);
            sb.append("====================================================================").append(ConstantsUtil.NEW_LINE);
            this.logBuffer = sb.toString();
            SdkDebugLog.SDK_CORE_LOGGER.debugConfig(this.logBuffer, new Object[0]);
        }
    }

    public void setMaxIdleConns(int maxIdleConns) {
        this.maxIdleConns = maxIdleConns;
    }

    public void setKeepAliveDurationMs(long keepAliveDurationMs) {
        this.keepAliveDurationMs = keepAliveDurationMs;
    }

    public void setDisableSSL(boolean disableSSL) {
        this.disableSSL = disableSSL;
    }

    public void setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
    }

    public void setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
    }

    public void setHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setAutoRetry(boolean autoRetry) {
        this.autoRetry = autoRetry;
    }

    public void setMinRetryDelayMs(long minRetryDelayMs) {
        this.minRetryDelayMs = minRetryDelayMs;
    }

    public void setMaxRetryDelayMs(long maxRetryDelayMs) {
        this.maxRetryDelayMs = maxRetryDelayMs;
    }

    public void setRetryCondition(RetryCondition retryCondition) {
        this.retryCondition = retryCondition;
    }

    public void setBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
    }

    public void setRetryErrorCode(Set<String> retryErrorCode) {
        this.retryErrorCode = retryErrorCode;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setUseDualStack(Boolean useDualStack) {
        this.useDualStack = useDualStack;
    }

    public void setCustomBootstrapRegion(Set<String> customBootstrapRegion) {
        this.customBootstrapRegion = customBootstrapRegion;
    }

    public void setEndpointResolver(EndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }
}

