/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.observability.debugger;

public enum LogLevel {
    LOG_DEBUG_OFF(0, new LogLevel[0]),
    LOG_DEBUG_WITH_REQUEST(1, new LogLevel[0]),
    LOG_DEBUG_WITH_REQUEST_BODY(2, LOG_DEBUG_WITH_REQUEST),
    LOG_DEBUG_WITH_REQUEST_ID(3, LOG_DEBUG_WITH_REQUEST),
    LOG_DEBUG_WITH_RESPONSE(4, LOG_DEBUG_WITH_REQUEST),
    LOG_DEBUG_WITH_RESPONSE_BODY(5, LOG_DEBUG_WITH_RESPONSE),
    LOG_DEBUG_WITH_SIGNING(6, LOG_DEBUG_WITH_REQUEST),
    LOG_DEBUG_WITH_ENDPOINT(7, LOG_DEBUG_WITH_REQUEST),
    LOG_DEBUG_WITH_REQUEST_RETRIES(8, LOG_DEBUG_WITH_REQUEST),
    LOG_DEBUG_WITH_CONFIG(9, LOG_DEBUG_WITH_REQUEST),
    LOG_DEBUG_ALL(-1, new LogLevel[0]);

    private final int bitIndex;
    private long mask;

    private LogLevel(int bitIndex, LogLevel ... parents) {
        this.bitIndex = bitIndex;
        if (bitIndex >= 0) {
            long m = 1L << bitIndex;
            if (parents != null) {
                for (LogLevel p : parents) {
                    m |= p.mask;
                }
            }
            this.mask = m;
        }
    }

    public long mask() {
        return this.mask;
    }

    public static long combine(LogLevel ... modes) {
        if (modes.length == 0) {
            return LogLevel.LOG_DEBUG_OFF.mask;
        }
        long f = 0L;
        for (LogLevel m : modes) {
            f |= m.mask;
        }
        return f;
    }

    public boolean matches(long flags) {
        return (flags & this.mask) == this.mask;
    }

    static {
        long all = 0L;
        for (LogLevel l : LogLevel.values()) {
            if (l == LOG_DEBUG_OFF || l == LOG_DEBUG_ALL) continue;
            all |= l.mask;
        }
        LogLevel.LOG_DEBUG_ALL.mask = all;
    }

    private static class Test {
        private Test() {
        }

        public static void main(String[] args) {
            long flag = LogLevel.combine(LOG_DEBUG_WITH_REQUEST, LOG_DEBUG_WITH_RESPONSE, LOG_DEBUG_WITH_REQUEST_BODY);
            System.out.println(LOG_DEBUG_WITH_REQUEST.matches(flag));
            System.out.println(LOG_DEBUG_WITH_RESPONSE.matches(flag));
            System.out.println(LOG_DEBUG_WITH_REQUEST_BODY.matches(flag));
            long flag1 = LOG_DEBUG_ALL.mask;
            System.out.println(LOG_DEBUG_WITH_REQUEST.matches(flag1));
            System.out.println(LOG_DEBUG_WITH_RESPONSE.matches(flag1));
            System.out.println(LOG_DEBUG_WITH_REQUEST_BODY.matches(flag1));
        }
    }
}

