/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.content.generation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ListContentGenerationTasksRequest {
    @JsonProperty(value="page_num")
    private Integer pageNum;
    @JsonProperty(value="page_size")
    private Integer pageSize;
    private String status;
    private String model;
    private List<String> taskIds;
    private String serviceTier;

    public ListContentGenerationTasksRequest() {
    }

    public ListContentGenerationTasksRequest(Integer pageNum, Integer pageSize, String status, String model, List<String> taskIds) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.status = status;
        this.model = model;
        this.taskIds = taskIds;
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public List<String> getTaskIds() {
        return this.taskIds;
    }

    public void setTaskIds(List<String> taskIds) {
        this.taskIds = taskIds;
    }

    public String getServiceTier() {
        return this.serviceTier;
    }

    public void setServiceTier(String serviceTier) {
        this.serviceTier = serviceTier;
    }

    public String toString() {
        return "ListContentGenerationTasksRequest{pageNum=" + this.pageNum + ", pageSize=" + this.pageSize + ", status='" + this.status + '\'' + ", model='" + this.model + '\'' + ", taskIds=" + this.taskIds + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer pageNum;
        private Integer pageSize;
        private String status;
        private String model;
        private final List<String> taskIds = new ArrayList<String>();
        private String serviceTier;

        public Builder pageNum(Integer pageNum) {
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder status(String status) {
            this.status = status.toString();
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        public Builder taskIds(List<String> taskIds) {
            this.taskIds.clear();
            this.taskIds.addAll(taskIds);
            return this;
        }

        public Builder addTaskId(String taskId) {
            this.taskIds.add(taskId);
            return this;
        }

        public ListContentGenerationTasksRequest build() {
            ListContentGenerationTasksRequest req = new ListContentGenerationTasksRequest(this.pageNum, this.pageSize, this.status, this.model, this.taskIds);
            req.setServiceTier(this.serviceTier);
            return req;
        }
    }
}

