/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.condition;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.integration.test.condition.LogLevels;
import org.springframework.integration.test.util.TestUtils;

public class LogLevelsCondition
implements ExecutionCondition,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final String STORE_ANNOTATION_KEY = "logLevelsAnnotation";
    private static final String STORE_CONTAINER_KEY = "logLevelsContainer";
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@LogLevels always enabled");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)((AnnotatedElement)element.get()), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotation mergedAnnotation = annotations.get(LogLevels.class);
        if (mergedAnnotation.isPresent()) {
            LogLevels loglevels = (LogLevels)mergedAnnotation.synthesize();
            ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
            store.put((Object)STORE_ANNOTATION_KEY, (Object)loglevels);
        }
        return ENABLED;
    }

    public void beforeEach(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
        LogLevels logLevels = (LogLevels)store.get((Object)STORE_ANNOTATION_KEY, LogLevels.class);
        if (logLevels == null) {
            ExtensionContext parent = (ExtensionContext)context.getParent().get();
            store = parent.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), parent}));
            logLevels = (LogLevels)store.get((Object)STORE_ANNOTATION_KEY, LogLevels.class);
        }
        store.put((Object)STORE_CONTAINER_KEY, (Object)TestUtils.adjustLogLevels(context.getDisplayName(), Arrays.asList(logLevels.classes()), Arrays.asList(logLevels.categories()), Level.toLevel((String)logLevels.level())));
    }

    public void afterEach(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
        TestUtils.LevelsContainer container = (TestUtils.LevelsContainer)store.get((Object)STORE_CONTAINER_KEY, TestUtils.LevelsContainer.class);
        boolean parentStore = false;
        if (container == null) {
            ExtensionContext parent = (ExtensionContext)context.getParent().get();
            store = parent.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), parent}));
            container = (TestUtils.LevelsContainer)store.get((Object)STORE_CONTAINER_KEY, TestUtils.LevelsContainer.class);
            parentStore = true;
        }
        TestUtils.revertLogLevels(context.getDisplayName(), container);
        store.remove((Object)STORE_CONTAINER_KEY);
        if (!parentStore) {
            store.remove((Object)STORE_ANNOTATION_KEY);
        }
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
        store.remove((Object)STORE_ANNOTATION_KEY);
    }
}

