/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.config.EnableMessageHistory;
import org.springframework.integration.history.MessageHistoryConfigurer;
import org.springframework.util.StringUtils;

public class MessageHistoryRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition("messageHistoryConfigurer")) {
            throw new BeanDefinitionStoreException("Only one @EnableMessageHistory or <message-history/> can be declared in the application context.");
        }
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnableMessageHistory.class.getName());
        Object componentNamePatterns = annotationAttributes.get("value");
        String patterns = componentNamePatterns instanceof String[] ? String.join((CharSequence)",", (String[])componentNamePatterns) : (String)componentNamePatterns;
        registry.registerBeanDefinition("messageHistoryConfigurer", (BeanDefinition)new RootBeanDefinition(MessageHistoryConfigurer.class, () -> this.createMessageHistoryConfigurer(registry, patterns)));
    }

    private MessageHistoryConfigurer createMessageHistoryConfigurer(BeanDefinitionRegistry registry, String patterns) {
        MessageHistoryConfigurer messageHistoryConfigurer = new MessageHistoryConfigurer();
        if (StringUtils.hasText((String)patterns)) {
            ConfigurableBeanFactory beanFactory = null;
            if (registry instanceof ConfigurableBeanFactory) {
                beanFactory = (ConfigurableBeanFactory)registry;
            } else if (registry instanceof ConfigurableApplicationContext) {
                beanFactory = ((ConfigurableApplicationContext)registry).getBeanFactory();
            }
            String[] patternsToSet = StringUtils.delimitedListToStringArray((String)patterns, (String)",", (String)" ");
            if (beanFactory != null) {
                patternsToSet = (String[])Arrays.stream(patternsToSet).map(arg_0 -> ((ConfigurableBeanFactory)beanFactory).resolveEmbeddedValue(arg_0)).flatMap(pattern -> Arrays.stream(StringUtils.delimitedListToStringArray((String)pattern, (String)",", (String)" "))).toArray(String[]::new);
            }
            messageHistoryConfigurer.setComponentNamePatterns(patternsToSet);
        }
        return messageHistoryConfigurer;
    }
}

