/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived.latency;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.terracotta.statistics.Sample;
import org.terracotta.statistics.SampledStatistic;
import org.terracotta.statistics.StatisticType;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.derived.latency.LatencyPeriodAccumulator;
import org.terracotta.statistics.observer.ChainedEventObserver;

public class MaximumLatencyHistory
implements ChainedEventObserver,
SampledStatistic<Long> {
    private final AtomicReference<LatencyPeriodAccumulator> latestAccumulator = new AtomicReference();
    private final Queue<LatencyPeriodAccumulator> archive;
    private final long windowSizeNs;
    private final Consumer<LatencyPeriodAccumulator> sink;
    private final LongSupplier timeSupplier;
    private volatile long drift;

    public MaximumLatencyHistory(int historySize, long windowSize, TimeUnit windowSizeUnit, LongSupplier timeSupplier) {
        this(historySize, windowSize, windowSizeUnit, timeSupplier, accumulator -> {});
    }

    public MaximumLatencyHistory(int historySize, long windowSize, TimeUnit windowSizeUnit, LongSupplier timeSupplier, Consumer<LatencyPeriodAccumulator> sink) {
        this.archive = new ArrayBlockingQueue<LatencyPeriodAccumulator>(historySize);
        this.windowSizeNs = TimeUnit.NANOSECONDS.convert(windowSize, windowSizeUnit);
        this.sink = sink;
        this.timeSupplier = timeSupplier;
        this.drift = Time.time() - timeSupplier.getAsLong() * 1000000L;
    }

    @Override
    public void event(long timeNs, long latencyNs) {
        LatencyPeriodAccumulator newAccumulator;
        LatencyPeriodAccumulator accumulator;
        do {
            if ((accumulator = this.latestAccumulator.get()) == null || !accumulator.tryAccumulate(timeNs, latencyNs)) continue;
            return;
        } while (!this.latestAccumulator.compareAndSet(accumulator, newAccumulator = new LatencyPeriodAccumulator(timeNs, this.windowSizeNs, latencyNs)));
        this.drift = Time.time() - this.timeSupplier.getAsLong() * 1000000L;
        this.insert(newAccumulator);
    }

    @Override
    public Long value() {
        LatencyPeriodAccumulator accumulator = this.latestAccumulator.get();
        if (accumulator == null || accumulator.end() <= Time.time()) {
            return null;
        }
        return accumulator.maximum();
    }

    @Override
    public StatisticType type() {
        return StatisticType.GAUGE;
    }

    @Override
    public List<Sample<Long>> history() {
        long drift = this.drift;
        return this.archive.stream().map(acumulator -> new Sample<Long>((acumulator.start() - drift) / 1000000L, acumulator.maximum())).collect(Collectors.toList());
    }

    @Override
    public List<Sample<Long>> history(long sinceMillis) {
        long drift = this.drift;
        long sinceNs = sinceMillis * 1000000L + drift;
        return this.archive.stream().filter(acumulator -> acumulator.start() >= sinceNs).map(acumulator -> new Sample<Long>((acumulator.start() - drift) / 1000000L, acumulator.maximum())).collect(Collectors.toList());
    }

    private void insert(LatencyPeriodAccumulator newAccumulator) {
        while (!this.archive.offer(newAccumulator)) {
            LatencyPeriodAccumulator removed = this.archive.poll();
            if (removed == null) continue;
            this.sink.accept(removed);
        }
    }
}

