/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived.latency;

import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.terracotta.statistics.derived.latency.LatencyStatistic;
import org.terracotta.statistics.observer.ChainedEventObserver;

public class LatencyAccumulator
implements LatencyStatistic,
ChainedEventObserver {
    private static final long DEFAULT_MIN = Long.MAX_VALUE;
    private static final long DEFAULT_MAX = Long.MIN_VALUE;
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final LongAccumulator minimum = new LongAccumulator(Math::min, Long.MAX_VALUE);
    private final LongAccumulator maximum = new LongAccumulator(Math::max, Long.MIN_VALUE);

    private LatencyAccumulator(long ... latencies) {
        for (long latency : latencies) {
            this.accumulate(latency);
        }
    }

    public void accumulate(long latency) {
        this.count.increment();
        this.total.add(latency);
        this.minimum.accumulate(latency);
        this.maximum.accumulate(latency);
    }

    public void accumulate(LatencyAccumulator accumulator) {
        this.count.add(accumulator.count());
        this.total.add(accumulator.total());
        this.minimum.accumulate(accumulator.minimum());
        this.maximum.accumulate(accumulator.maximum());
    }

    public long count() {
        return this.count.sum();
    }

    public long total() {
        return this.total.sum();
    }

    public boolean isEmpty() {
        return this.count.sum() == 0L;
    }

    @Override
    public void event(long time, long latency) {
        this.accumulate(latency);
    }

    @Override
    public Long maximum() {
        return this.isEmpty() ? null : Long.valueOf(this.maximum.get());
    }

    @Override
    public Long minimum() {
        return this.isEmpty() ? null : Long.valueOf(this.minimum.get());
    }

    @Override
    public double average() {
        return (double)this.total.sum() / (double)this.count.sum();
    }

    public String toString() {
        return "LatencyAccumulator{count=" + this.count() + ", total=" + this.total() + ", minimum=" + this.minimum() + ", maximum=" + this.maximum() + ", average=" + this.average() + '}';
    }

    public static LatencyAccumulator accumulator(long ... latencies) {
        return new LatencyAccumulator(latencies);
    }

    public static LatencyAccumulator empty() {
        return new LatencyAccumulator(new long[0]);
    }
}

