/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.heap.holders;

import java.time.Duration;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.store.heap.holders.OnHeapValueHolder;
import org.ehcache.sizeof.annotations.IgnoreSizeOf;
import org.ehcache.spi.copy.Copier;

public class CopiedOnHeapValueHolder<V>
extends OnHeapValueHolder<V> {
    private final V copiedValue;
    @IgnoreSizeOf
    private final Copier<V> valueCopier;

    protected CopiedOnHeapValueHolder(long id, V value, long creationTime, long expirationTime, boolean evictionAdvice, Copier<V> valueCopier) {
        super(id, creationTime, expirationTime, evictionAdvice);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (valueCopier == null) {
            throw new NullPointerException("null copier");
        }
        this.valueCopier = valueCopier;
        this.copiedValue = valueCopier.copyForWrite(value);
    }

    public CopiedOnHeapValueHolder(Store.ValueHolder<V> valueHolder, V value, boolean evictionAdvice, Copier<V> valueCopier, long now, Duration expiration) {
        super(valueHolder.getId(), valueHolder.creationTime(TIME_UNIT), valueHolder.expirationTime(TIME_UNIT), evictionAdvice);
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (valueCopier == null) {
            throw new NullPointerException("null copier");
        }
        this.valueCopier = valueCopier;
        this.copiedValue = value;
        this.setHits(valueHolder.hits());
        this.accessed(now, expiration);
    }

    public CopiedOnHeapValueHolder(V value, long creationTime, boolean evictionAdvice, Copier<V> valueCopier) {
        this(value, creationTime, -1L, evictionAdvice, valueCopier);
    }

    public CopiedOnHeapValueHolder(V value, long creationTime, long expirationTime, boolean evictionAdvice, Copier<V> valueCopier) {
        this(-1L, value, creationTime, expirationTime, evictionAdvice, valueCopier);
    }

    @Override
    public V get() {
        return this.valueCopier.copyForRead(this.copiedValue);
    }
}

