/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.encode;

import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import ws.schild.jave.encode.ArgType;
import ws.schild.jave.encode.EncodingArgument;
import ws.schild.jave.encode.EncodingAttributes;

public class PredicateArgument
implements EncodingArgument {
    private ArgType argumentType;
    private Supplier<Stream<String>> arguments;
    private Predicate<EncodingAttributes> predicate;

    public PredicateArgument(ArgType argType, String argument, Predicate<EncodingAttributes> predicate) {
        this.argumentType = argType;
        this.arguments = () -> Stream.of(argument);
        this.predicate = predicate;
    }

    public PredicateArgument(ArgType argType, String argument1, String argument2, Predicate<EncodingAttributes> predicate) {
        this.argumentType = argType;
        this.arguments = () -> Stream.of(argument1, argument2);
        this.predicate = predicate;
    }

    @Override
    public Stream<String> getArguments(EncodingAttributes context) {
        if (this.predicate.test(context)) {
            return this.arguments.get();
        }
        return Stream.empty();
    }

    @Override
    public ArgType getArgType() {
        return this.argumentType;
    }
}

