/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;

public class IOUtils {
    public static final String SYSTEM_CHAR_SET = Charset.defaultCharset().name();

    public static String inputStreamAsString(InputStream inputStream, String charEncoding) throws IOException {
        int bytesRead;
        if (charEncoding == null) {
            charEncoding = SYSTEM_CHAR_SET;
        }
        StringWriter sw = new StringWriter();
        InputStreamReader in = new InputStreamReader(inputStream, charEncoding);
        char[] buffer = new char[4096];
        while (-1 != (bytesRead = in.read(buffer))) {
            sw.write(buffer, 0, bytesRead);
        }
        return sw.toString();
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

