/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.MethodIntrospector;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractHandlerMethodMapping<T>
extends AbstractHandlerMapping
implements InitializingBean {
    private static final String SCOPED_TARGET_NAME_PREFIX = "scopedTarget.";
    private static final HandlerMethod PREFLIGHT_AMBIGUOUS_MATCH = new HandlerMethod((Object)new PreFlightAmbiguousMatchHandler(), ClassUtils.getMethod(PreFlightAmbiguousMatchHandler.class, (String)"handle", (Class[])new Class[0]));
    private static final CorsConfiguration ALLOW_CORS_CONFIG = new CorsConfiguration();
    private final MappingRegistry mappingRegistry = new MappingRegistry();

    public Map<T, HandlerMethod> getHandlerMethods() {
        this.mappingRegistry.acquireReadLock();
        try {
            Map map = Collections.unmodifiableMap(this.mappingRegistry.getMappings());
            return map;
        }
        finally {
            this.mappingRegistry.releaseReadLock();
        }
    }

    MappingRegistry getMappingRegistry() {
        return this.mappingRegistry;
    }

    public void registerMapping(T mapping, Object handler, Method method2) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Register \"" + mapping + "\" to " + method2.toGenericString()));
        }
        this.mappingRegistry.register(mapping, handler, method2);
    }

    public void unregisterMapping(T mapping) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Unregister mapping \"" + mapping));
        }
        this.mappingRegistry.unregister(mapping);
    }

    public void afterPropertiesSet() {
        this.initHandlerMethods();
        int total = this.getHandlerMethods().size();
        if (this.logger.isTraceEnabled() && total == 0 || this.logger.isDebugEnabled() && total > 0) {
            this.logger.debug((Object)(total + " mappings in " + this.formatMappingName()));
        }
    }

    protected void initHandlerMethods() {
        String[] beanNames;
        for (String beanName : beanNames = this.obtainApplicationContext().getBeanNamesForType(Object.class)) {
            Class beanType;
            block3: {
                if (beanName.startsWith(SCOPED_TARGET_NAME_PREFIX)) continue;
                beanType = null;
                try {
                    beanType = this.obtainApplicationContext().getType(beanName);
                }
                catch (Throwable ex) {
                    if (!this.logger.isTraceEnabled()) break block3;
                    this.logger.trace((Object)("Could not resolve type for bean '" + beanName + "'"), ex);
                }
            }
            if (beanType == null || !this.isHandler(beanType)) continue;
            this.detectHandlerMethods(beanName);
        }
        this.handlerMethodsInitialized(this.getHandlerMethods());
    }

    protected void detectHandlerMethods(Object handler) {
        Class handlerType;
        Class clazz = handlerType = handler instanceof String ? this.obtainApplicationContext().getType((String)handler) : handler.getClass();
        if (handlerType != null) {
            Class userType = ClassUtils.getUserClass((Class)handlerType);
            Map methods = MethodIntrospector.selectMethods((Class)userType, method2 -> this.getMappingForMethod(method2, userType));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Mapped " + methods.size() + " handler method(s) for " + userType + ": " + methods));
            }
            methods.forEach((key, mapping) -> {
                Method invocableMethod = AopUtils.selectInvocableMethod((Method)key, (Class)userType);
                this.registerHandlerMethod(handler, invocableMethod, mapping);
            });
        }
    }

    protected void registerHandlerMethod(Object handler, Method method2, T mapping) {
        this.mappingRegistry.register(mapping, handler, method2);
    }

    protected HandlerMethod createHandlerMethod(Object handler, Method method2) {
        HandlerMethod handlerMethod;
        if (handler instanceof String) {
            String beanName = (String)handler;
            handlerMethod = new HandlerMethod(beanName, (BeanFactory)this.obtainApplicationContext().getAutowireCapableBeanFactory(), method2);
        } else {
            handlerMethod = new HandlerMethod(handler, method2);
        }
        return handlerMethod;
    }

    @Nullable
    protected CorsConfiguration initCorsConfiguration(Object handler, Method method2, T mapping) {
        return null;
    }

    protected void handlerMethodsInitialized(Map<T, HandlerMethod> handlerMethods) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<HandlerMethod> getHandlerInternal(ServerWebExchange exchange) {
        this.mappingRegistry.acquireReadLock();
        try {
            HandlerMethod handlerMethod;
            try {
                handlerMethod = this.lookupHandlerMethod(exchange);
            }
            catch (Exception ex) {
                Mono mono = Mono.error((Throwable)ex);
                this.mappingRegistry.releaseReadLock();
                return mono;
            }
            if (handlerMethod != null) {
                handlerMethod = handlerMethod.createWithResolvedBean();
            }
            Mono mono = Mono.justOrEmpty((Object)handlerMethod);
            return mono;
        }
        finally {
            this.mappingRegistry.releaseReadLock();
        }
    }

    @Nullable
    protected HandlerMethod lookupHandlerMethod(ServerWebExchange exchange) throws Exception {
        ArrayList<Match> matches = new ArrayList<Match>();
        this.addMatchingMappings(this.mappingRegistry.getMappings().keySet(), matches, exchange);
        if (!matches.isEmpty()) {
            MatchComparator comparator = new MatchComparator(this.getMappingComparator(exchange));
            matches.sort(comparator);
            Match bestMatch = (Match)matches.get(0);
            if (matches.size() > 1) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(exchange.getLogPrefix() + matches.size() + " matching mappings: " + matches));
                }
                if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange.getRequest())) {
                    return PREFLIGHT_AMBIGUOUS_MATCH;
                }
                Match secondBestMatch = (Match)matches.get(1);
                if (comparator.compare(bestMatch, secondBestMatch) == 0) {
                    Method m1 = bestMatch.handlerMethod.getMethod();
                    Method m2 = secondBestMatch.handlerMethod.getMethod();
                    RequestPath path2 = exchange.getRequest().getPath();
                    throw new IllegalStateException("Ambiguous handler methods mapped for '" + path2 + "': {" + m1 + ", " + m2 + "}");
                }
            }
            this.handleMatch(bestMatch.mapping, bestMatch.handlerMethod, exchange);
            return bestMatch.handlerMethod;
        }
        return this.handleNoMatch(this.mappingRegistry.getMappings().keySet(), exchange);
    }

    private void addMatchingMappings(Collection<T> mappings, List<Match> matches, ServerWebExchange exchange) {
        for (T mapping : mappings) {
            T match = this.getMatchingMapping(mapping, exchange);
            if (match == null) continue;
            matches.add(new Match(match, this.mappingRegistry.getMappings().get(mapping)));
        }
    }

    protected void handleMatch(T mapping, HandlerMethod handlerMethod, ServerWebExchange exchange) {
    }

    @Nullable
    protected HandlerMethod handleNoMatch(Set<T> mappings, ServerWebExchange exchange) throws Exception {
        return null;
    }

    @Override
    protected CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange) {
        CorsConfiguration corsConfig = super.getCorsConfiguration(handler, exchange);
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            if (handlerMethod.equals((Object)PREFLIGHT_AMBIGUOUS_MATCH)) {
                return ALLOW_CORS_CONFIG;
            }
            CorsConfiguration methodConfig = this.mappingRegistry.getCorsConfiguration(handlerMethod);
            corsConfig = corsConfig != null ? corsConfig.combine(methodConfig) : methodConfig;
        }
        return corsConfig;
    }

    protected abstract boolean isHandler(Class<?> var1);

    @Nullable
    protected abstract T getMappingForMethod(Method var1, Class<?> var2);

    @Nullable
    protected abstract T getMatchingMapping(T var1, ServerWebExchange var2);

    protected abstract Comparator<T> getMappingComparator(ServerWebExchange var1);

    static {
        ALLOW_CORS_CONFIG.addAllowedOrigin("*");
        ALLOW_CORS_CONFIG.addAllowedMethod("*");
        ALLOW_CORS_CONFIG.addAllowedHeader("*");
        ALLOW_CORS_CONFIG.setAllowCredentials(Boolean.valueOf(true));
    }

    private static class PreFlightAmbiguousMatchHandler {
        private PreFlightAmbiguousMatchHandler() {
        }

        public void handle() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private class MatchComparator
    implements Comparator<Match> {
        private final Comparator<T> comparator;

        public MatchComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Match match1, Match match2) {
            return this.comparator.compare(match1.mapping, match2.mapping);
        }
    }

    private class Match {
        private final T mapping;
        private final HandlerMethod handlerMethod;

        public Match(T mapping, HandlerMethod handlerMethod) {
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }

    private static class MappingRegistration<T> {
        private final T mapping;
        private final HandlerMethod handlerMethod;

        public MappingRegistration(T mapping, HandlerMethod handlerMethod) {
            Assert.notNull(mapping, (String)"Mapping must not be null");
            Assert.notNull((Object)handlerMethod, (String)"HandlerMethod must not be null");
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
        }

        public T getMapping() {
            return this.mapping;
        }

        public HandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }
    }

    class MappingRegistry {
        private final Map<T, MappingRegistration<T>> registry = new HashMap();
        private final Map<T, HandlerMethod> mappingLookup = new LinkedHashMap();
        private final Map<HandlerMethod, CorsConfiguration> corsLookup = new ConcurrentHashMap<HandlerMethod, CorsConfiguration>();
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        MappingRegistry() {
        }

        public Map<T, HandlerMethod> getMappings() {
            return this.mappingLookup;
        }

        public CorsConfiguration getCorsConfiguration(HandlerMethod handlerMethod) {
            HandlerMethod original = handlerMethod.getResolvedFromHandlerMethod();
            return this.corsLookup.get(original != null ? original : handlerMethod);
        }

        public void acquireReadLock() {
            this.readWriteLock.readLock().lock();
        }

        public void releaseReadLock() {
            this.readWriteLock.readLock().unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(T mapping, Object handler, Method method2) {
            this.readWriteLock.writeLock().lock();
            try {
                HandlerMethod handlerMethod = AbstractHandlerMethodMapping.this.createHandlerMethod(handler, method2);
                this.assertUniqueMethodMapping(handlerMethod, mapping);
                this.mappingLookup.put(mapping, handlerMethod);
                CorsConfiguration corsConfig = AbstractHandlerMethodMapping.this.initCorsConfiguration(handler, method2, mapping);
                if (corsConfig != null) {
                    this.corsLookup.put(handlerMethod, corsConfig);
                }
                this.registry.put(mapping, new MappingRegistration(mapping, handlerMethod));
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }

        private void assertUniqueMethodMapping(HandlerMethod newHandlerMethod, T mapping) {
            HandlerMethod handlerMethod = this.mappingLookup.get(mapping);
            if (handlerMethod != null && !handlerMethod.equals((Object)newHandlerMethod)) {
                throw new IllegalStateException("Ambiguous mapping. Cannot map '" + newHandlerMethod.getBean() + "' method \n" + newHandlerMethod + "\nto " + mapping + ": There is already '" + handlerMethod.getBean() + "' bean method\n" + handlerMethod + " mapped.");
            }
        }

        public void unregister(T mapping) {
            this.readWriteLock.writeLock().lock();
            try {
                MappingRegistration definition = this.registry.remove(mapping);
                if (definition == null) {
                    return;
                }
                this.mappingLookup.remove(definition.getMapping());
                this.corsLookup.remove(definition.getHandlerMethod());
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }
}

