/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.ResultMatcher;

public class HeaderResultMatchers {
    protected HeaderResultMatchers() {
    }

    public ResultMatcher string(String name, Matcher<? super String> matcher) {
        return result -> MatcherAssert.assertThat((String)("Response header '" + name + "'"), (Object)result.getResponse().getHeader(name), (Matcher)matcher);
    }

    public <T> ResultMatcher stringValues(String name, Matcher<Iterable<String>> matcher) {
        return result -> {
            Collection values = result.getResponse().getHeaders(name);
            MatcherAssert.assertThat((String)("Response header '" + name + "'"), (Object)values, (Matcher)matcher);
        };
    }

    public ResultMatcher string(String name, String value) {
        return result -> AssertionErrors.assertEquals("Response header '" + name + "'", value, result.getResponse().getHeader(name));
    }

    public ResultMatcher stringValues(String name, String ... values) {
        return result -> {
            List<Object> actual = result.getResponse().getHeaderValues(name);
            AssertionErrors.assertEquals("Response header '" + name + "'", Arrays.asList(values), actual);
        };
    }

    public ResultMatcher exists(String name) {
        return result -> AssertionErrors.assertTrue("Response should contain header '" + name + "'", result.getResponse().containsHeader(name));
    }

    public ResultMatcher doesNotExist(String name) {
        return result -> AssertionErrors.assertTrue("Response should not contain header '" + name + "'", !result.getResponse().containsHeader(name));
    }

    public ResultMatcher longValue(String name, long value) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            AssertionErrors.assertTrue("Response does not contain header '" + name + "'", response.containsHeader(name));
            String headerValue = response.getHeader(name);
            if (headerValue != null) {
                AssertionErrors.assertEquals("Response header '" + name + "'", value, Long.parseLong(headerValue));
            }
        };
    }

    public ResultMatcher dateValue(String name, long value) {
        return result -> {
            MockHttpServletResponse response = result.getResponse();
            String headerValue = response.getHeader(name);
            AssertionErrors.assertNotNull("Response does not contain header '" + name + "'", headerValue);
            HttpHeaders headers = new HttpHeaders();
            headers.setDate("expected", value);
            headers.set("actual", headerValue);
            AssertionErrors.assertEquals("Response header '" + name + "'='" + headerValue + "' does not match expected value '" + headers.getFirst("expected") + "'", headers.getFirstDate("expected"), headers.getFirstDate("actual"));
        };
    }
}

