/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.metadata.CompositeMetadataFlyweight;
import io.rsocket.metadata.TaggingMetadataFlyweight;
import io.rsocket.metadata.WellKnownMimeType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.PayloadUtils;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;

final class MetadataEncoder {
    private static final Pattern VARS_PATTERN = Pattern.compile("\\{([^/]+?)}");
    private final MimeType metadataMimeType;
    private final RSocketStrategies strategies;
    private final boolean isComposite;
    private final ByteBufAllocator allocator;
    @Nullable
    private String route;
    private final Map<Object, MimeType> metadata = new LinkedHashMap<Object, MimeType>(4);

    MetadataEncoder(MimeType metadataMimeType, RSocketStrategies strategies) {
        Assert.notNull((Object)metadataMimeType, (String)"'metadataMimeType' is required");
        Assert.notNull((Object)strategies, (String)"RSocketStrategies is required");
        this.metadataMimeType = metadataMimeType;
        this.strategies = strategies;
        this.isComposite = this.metadataMimeType.toString().equals(WellKnownMimeType.MESSAGE_RSOCKET_COMPOSITE_METADATA.getString());
        this.allocator = this.bufferFactory() instanceof NettyDataBufferFactory ? ((NettyDataBufferFactory)this.bufferFactory()).getByteBufAllocator() : ByteBufAllocator.DEFAULT;
    }

    private DataBufferFactory bufferFactory() {
        return this.strategies.dataBufferFactory();
    }

    public MetadataEncoder route(String route, Object ... routeVars) {
        this.route = MetadataEncoder.expand(route, routeVars);
        this.assertMetadataEntryCount();
        return this;
    }

    private static String expand(String route, Object ... routeVars) {
        if (ObjectUtils.isEmpty((Object[])routeVars)) {
            return route;
        }
        StringBuffer sb = new StringBuffer();
        int index = 0;
        Matcher matcher = VARS_PATTERN.matcher(route);
        while (matcher.find()) {
            Assert.isTrue((index < routeVars.length ? 1 : 0) != 0, () -> "No value for variable '" + matcher.group(1) + "'");
            String value = routeVars[index].toString();
            value = value.contains(".") ? value.replaceAll("\\.", "%2E") : value;
            matcher.appendReplacement(sb, value);
            ++index;
        }
        return sb.toString();
    }

    private void assertMetadataEntryCount() {
        if (!this.isComposite) {
            int count = this.route != null ? this.metadata.size() + 1 : this.metadata.size();
            Assert.isTrue((count < 2 ? 1 : 0) != 0, (String)"Composite metadata required for multiple metadata entries.");
        }
    }

    public MetadataEncoder metadata(Object metadata, @Nullable MimeType mimeType) {
        if (this.isComposite) {
            Assert.notNull((Object)mimeType, (String)"MimeType is required for composite metadata entries.");
        } else if (mimeType == null) {
            mimeType = this.metadataMimeType;
        } else if (!this.metadataMimeType.equals((Object)mimeType)) {
            throw new IllegalArgumentException("Mime type is optional (may be null) but was provided and does not match the connection metadata mime type.");
        }
        this.metadata.put(metadata, mimeType);
        this.assertMetadataEntryCount();
        return this;
    }

    public MetadataEncoder metadataAndOrRoute(@Nullable Map<Object, MimeType> metadata, @Nullable String route, @Nullable Object[] vars) {
        if (route != null) {
            this.route = MetadataEncoder.expand(route, vars != null ? vars : new Object[]{});
        }
        if (!CollectionUtils.isEmpty(metadata)) {
            for (Map.Entry<Object, MimeType> entry : metadata.entrySet()) {
                this.metadata(entry.getKey(), entry.getValue());
            }
        }
        this.assertMetadataEntryCount();
        return this;
    }

    public DataBuffer encode() {
        if (this.isComposite) {
            CompositeByteBuf composite = this.allocator.compositeBuffer();
            try {
                if (this.route != null) {
                    CompositeMetadataFlyweight.encodeAndAddMetadata((CompositeByteBuf)composite, (ByteBufAllocator)this.allocator, (WellKnownMimeType)WellKnownMimeType.MESSAGE_RSOCKET_ROUTING, (ByteBuf)this.encodeRoute());
                }
                this.metadata.forEach((value, mimeType) -> {
                    ByteBuf metadata = value instanceof ByteBuf ? (ByteBuf)value : PayloadUtils.asByteBuf(this.encodeEntry(value, (MimeType)mimeType));
                    CompositeMetadataFlyweight.encodeAndAddMetadata((CompositeByteBuf)composite, (ByteBufAllocator)this.allocator, (String)mimeType.toString(), (ByteBuf)metadata);
                });
                return this.asDataBuffer((ByteBuf)composite);
            }
            catch (Throwable ex) {
                composite.release();
                throw ex;
            }
        }
        if (this.route != null) {
            Assert.isTrue((boolean)this.metadata.isEmpty(), (String)"Composite metadata required for route and other entries");
            String routingMimeType = WellKnownMimeType.MESSAGE_RSOCKET_ROUTING.getString();
            return this.metadataMimeType.toString().equals(routingMimeType) ? this.asDataBuffer(this.encodeRoute()) : this.encodeEntry(this.route, this.metadataMimeType);
        }
        Assert.isTrue((this.metadata.size() == 1 ? 1 : 0) != 0, (String)"Composite metadata required for multiple entries");
        Map.Entry<Object, MimeType> entry = this.metadata.entrySet().iterator().next();
        if (!this.metadataMimeType.equals((Object)entry.getValue())) {
            throw new IllegalArgumentException("Connection configured for metadata mime type '" + this.metadataMimeType + "', but actual is `" + this.metadata + "`");
        }
        return this.encodeEntry(entry.getKey(), entry.getValue());
    }

    private ByteBuf encodeRoute() {
        return TaggingMetadataFlyweight.createRoutingMetadata((ByteBufAllocator)this.allocator, Collections.singletonList(this.route)).getContent();
    }

    private <T> DataBuffer encodeEntry(Object metadata, MimeType mimeType) {
        if (metadata instanceof ByteBuf) {
            return this.asDataBuffer((ByteBuf)metadata);
        }
        ResolvableType type = ResolvableType.forInstance((Object)metadata);
        Encoder encoder = this.strategies.encoder(type, mimeType);
        Assert.notNull(encoder, () -> "No encoder for metadata " + metadata + ", mimeType '" + mimeType + "'");
        return encoder.encodeValue(metadata, this.bufferFactory(), type, mimeType, Collections.emptyMap());
    }

    private DataBuffer asDataBuffer(ByteBuf byteBuf) {
        if (this.bufferFactory() instanceof NettyDataBufferFactory) {
            return ((NettyDataBufferFactory)this.bufferFactory()).wrap(byteBuf);
        }
        DataBuffer buffer = this.bufferFactory().wrap(byteBuf.nioBuffer());
        byteBuf.release();
        return buffer;
    }
}

