/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.DefaultUserInfoRestTemplateFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.JwtAccessTokenConverterConfigurer;
import org.springframework.boot.autoconfigure.security.oauth2.resource.JwtAccessTokenConverterRestTemplateCustomizer;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.SpringSocialTokenServices;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateCustomizer;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoRestTemplateFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.RequestEnhancer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.oauth2.provider.token.store.KeyStoreKeyFactory;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnMissingBean(value={AuthorizationServerEndpointsConfiguration.class})
public class ResourceServerTokenServicesConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public UserInfoRestTemplateFactory userInfoRestTemplateFactory(ObjectProvider<List<UserInfoRestTemplateCustomizer>> customizers, ObjectProvider<OAuth2ProtectedResourceDetails> details, ObjectProvider<OAuth2ClientContext> oauth2ClientContext) {
        return new DefaultUserInfoRestTemplateFactory(customizers, details, oauth2ClientContext);
    }

    static class AcceptJsonRequestEnhancer
    implements RequestEnhancer {
        AcceptJsonRequestEnhancer() {
        }

        public void enhance(AccessTokenRequest request, OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form, HttpHeaders headers) {
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        }
    }

    static class AcceptJsonRequestInterceptor
    implements ClientHttpRequestInterceptor {
        AcceptJsonRequestInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            return execution.execute(request, body);
        }
    }

    private static class RemoteTokenCondition
    extends NoneNestedConditions {
        RemoteTokenCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={JwtKeyStoreCondition.class})
        static class HasKeyStoreConfiguration {
            HasKeyStoreConfiguration() {
            }
        }

        @Conditional(value={JwkCondition.class})
        static class HasJwkConfiguration {
            HasJwkConfiguration() {
            }
        }

        @Conditional(value={JwtTokenCondition.class})
        static class HasJwtConfiguration {
            HasJwtConfiguration() {
            }
        }
    }

    private static class NotTokenInfoCondition
    extends SpringBootCondition {
        private TokenInfoCondition tokenInfoCondition = new TokenInfoCondition();

        private NotTokenInfoCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return ConditionOutcome.inverse((ConditionOutcome)this.tokenInfoCondition.getMatchOutcome(context, metadata));
        }
    }

    private static class JwtKeyStoreCondition
    extends SpringBootCondition {
        private JwtKeyStoreCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"OAuth JWT KeyStore Condition", (Object[])new Object[0]);
            Environment environment = context.getEnvironment();
            String keyStore = environment.getProperty("security.oauth2.resource.jwt.key-store");
            if (StringUtils.hasText((String)keyStore)) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"provided key store location"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("key store location not provided").atAll());
        }
    }

    private static class JwkCondition
    extends SpringBootCondition {
        private JwkCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"OAuth JWK Condition", (Object[])new Object[0]);
            Environment environment = context.getEnvironment();
            String keyUri = environment.getProperty("security.oauth2.resource.jwk.key-set-uri");
            if (StringUtils.hasText((String)keyUri)) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"provided jwk key set URI"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("key jwk set URI not provided").atAll());
        }
    }

    private static class JwtTokenCondition
    extends SpringBootCondition {
        private JwtTokenCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"OAuth JWT Condition", (Object[])new Object[0]);
            Environment environment = context.getEnvironment();
            String keyValue = environment.getProperty("security.oauth2.resource.jwt.key-value");
            String keyUri = environment.getProperty("security.oauth2.resource.jwt.key-uri");
            if (StringUtils.hasText((String)keyValue) || StringUtils.hasText((String)keyUri)) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"provided public key"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("provided public key").atAll());
        }
    }

    private static class TokenInfoCondition
    extends SpringBootCondition {
        private TokenInfoCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"OAuth TokenInfo Condition", (Object[])new Object[0]);
            Environment environment = context.getEnvironment();
            Boolean preferTokenInfo = (Boolean)environment.getProperty("security.oauth2.resource.prefer-token-info", Boolean.class);
            if (preferTokenInfo == null) {
                preferTokenInfo = environment.resolvePlaceholders("${OAUTH2_RESOURCE_PREFERTOKENINFO:true}").equals("true");
            }
            String tokenInfoUri = environment.getProperty("security.oauth2.resource.token-info-uri");
            String userInfoUri = environment.getProperty("security.oauth2.resource.user-info-uri");
            if (!StringUtils.hasLength((String)userInfoUri) && !StringUtils.hasLength((String)tokenInfoUri)) {
                return ConditionOutcome.match((ConditionMessage)message.didNotFind("user-info-uri property").atAll());
            }
            if (StringUtils.hasLength((String)tokenInfoUri) && preferTokenInfo.booleanValue()) {
                return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)"preferred token-info-uri property"));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("token info").atAll());
        }
    }

    @Configuration
    @Conditional(value={JwtKeyStoreCondition.class})
    protected class JwtKeyStoreConfiguration
    implements ApplicationContextAware {
        private final ResourceServerProperties resource;
        private ApplicationContext context;

        @Autowired
        public JwtKeyStoreConfiguration(ResourceServerProperties resource) {
            this.resource = resource;
        }

        public void setApplicationContext(ApplicationContext context) throws BeansException {
            this.context = context;
        }

        @Bean
        @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
        public DefaultTokenServices jwtTokenServices(TokenStore jwtTokenStore) {
            DefaultTokenServices services = new DefaultTokenServices();
            services.setTokenStore(jwtTokenStore);
            return services;
        }

        @Bean
        @ConditionalOnMissingBean(value={TokenStore.class})
        public TokenStore tokenStore() {
            return new JwtTokenStore(this.accessTokenConverter());
        }

        @Bean
        @ConditionalOnMissingBean(value={JwtAccessTokenConverter.class})
        public JwtAccessTokenConverter accessTokenConverter() {
            Assert.notNull((Object)this.resource.getJwt().getKeyStore(), (String)"keyStore cannot be null");
            Assert.notNull((Object)this.resource.getJwt().getKeyStorePassword(), (String)"keyStorePassword cannot be null");
            Assert.notNull((Object)this.resource.getJwt().getKeyAlias(), (String)"keyAlias cannot be null");
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            Resource keyStore = this.context.getResource(this.resource.getJwt().getKeyStore());
            char[] keyStorePassword = this.resource.getJwt().getKeyStorePassword().toCharArray();
            KeyStoreKeyFactory keyStoreKeyFactory = new KeyStoreKeyFactory(keyStore, keyStorePassword);
            String keyAlias = this.resource.getJwt().getKeyAlias();
            char[] keyPassword = Optional.ofNullable(this.resource.getJwt().getKeyPassword()).map(String::toCharArray).orElse(keyStorePassword);
            converter.setKeyPair(keyStoreKeyFactory.getKeyPair(keyAlias, keyPassword));
            return converter;
        }
    }

    @Configuration
    @Conditional(value={JwtTokenCondition.class})
    protected static class JwtTokenServicesConfiguration {
        private final ResourceServerProperties resource;
        private final List<JwtAccessTokenConverterConfigurer> configurers;
        private final List<JwtAccessTokenConverterRestTemplateCustomizer> customizers;

        public JwtTokenServicesConfiguration(ResourceServerProperties resource, ObjectProvider<List<JwtAccessTokenConverterConfigurer>> configurers, ObjectProvider<List<JwtAccessTokenConverterRestTemplateCustomizer>> customizers) {
            this.resource = resource;
            this.configurers = (List)configurers.getIfAvailable();
            this.customizers = (List)customizers.getIfAvailable();
        }

        @Bean
        @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
        public DefaultTokenServices jwtTokenServices(TokenStore jwtTokenStore) {
            DefaultTokenServices services = new DefaultTokenServices();
            services.setTokenStore(jwtTokenStore);
            return services;
        }

        @Bean
        @ConditionalOnMissingBean(value={TokenStore.class})
        public TokenStore jwtTokenStore() {
            return new JwtTokenStore(this.jwtTokenEnhancer());
        }

        @Bean
        @ConditionalOnMissingBean(value={JwtAccessTokenConverter.class})
        public JwtAccessTokenConverter jwtTokenEnhancer() {
            JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
            String keyValue = this.resource.getJwt().getKeyValue();
            if (!StringUtils.hasText((String)keyValue)) {
                keyValue = this.getKeyFromServer();
            }
            if (StringUtils.hasText((String)keyValue) && !keyValue.startsWith("-----BEGIN")) {
                converter.setSigningKey(keyValue);
            }
            if (keyValue != null) {
                converter.setVerifierKey(keyValue);
            }
            if (!CollectionUtils.isEmpty(this.configurers)) {
                AnnotationAwareOrderComparator.sort(this.configurers);
                for (JwtAccessTokenConverterConfigurer configurer : this.configurers) {
                    configurer.configure(converter);
                }
            }
            return converter;
        }

        private String getKeyFromServer() {
            RestTemplate keyUriRestTemplate = new RestTemplate();
            if (!CollectionUtils.isEmpty(this.customizers)) {
                for (JwtAccessTokenConverterRestTemplateCustomizer customizer : this.customizers) {
                    customizer.customize(keyUriRestTemplate);
                }
            }
            HttpHeaders headers = new HttpHeaders();
            String username = this.resource.getClientId();
            String password = this.resource.getClientSecret();
            if (username != null && password != null) {
                byte[] token = Base64.getEncoder().encode((username + ":" + password).getBytes());
                headers.add("Authorization", "Basic " + new String(token));
            }
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            String url = this.resource.getJwt().getKeyUri();
            return (String)((Map)keyUriRestTemplate.exchange(url, HttpMethod.GET, request, Map.class, new Object[0]).getBody()).get("value");
        }
    }

    @Configuration
    @Conditional(value={JwkCondition.class})
    protected static class JwkTokenStoreConfiguration {
        private final ResourceServerProperties resource;

        public JwkTokenStoreConfiguration(ResourceServerProperties resource) {
            this.resource = resource;
        }

        @Bean
        @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
        public DefaultTokenServices jwkTokenServices(TokenStore jwkTokenStore) {
            DefaultTokenServices services = new DefaultTokenServices();
            services.setTokenStore(jwkTokenStore);
            return services;
        }

        @Bean
        @ConditionalOnMissingBean(value={TokenStore.class})
        public TokenStore jwkTokenStore() {
            return new JwkTokenStore(this.resource.getJwk().getKeySetUri());
        }
    }

    @Configuration
    @Conditional(value={RemoteTokenCondition.class})
    protected static class RemoteTokenServicesConfiguration {
        protected RemoteTokenServicesConfiguration() {
        }

        @Configuration
        @ConditionalOnMissingClass(value={"org.springframework.social.connect.support.OAuth2ConnectionFactory"})
        @Conditional(value={NotTokenInfoCondition.class})
        protected static class UserInfoTokenServicesConfiguration {
            private final ResourceServerProperties sso;
            private final OAuth2RestOperations restTemplate;
            private final AuthoritiesExtractor authoritiesExtractor;
            private final PrincipalExtractor principalExtractor;

            public UserInfoTokenServicesConfiguration(ResourceServerProperties sso, UserInfoRestTemplateFactory restTemplateFactory, ObjectProvider<AuthoritiesExtractor> authoritiesExtractor, ObjectProvider<PrincipalExtractor> principalExtractor) {
                this.sso = sso;
                this.restTemplate = restTemplateFactory.getUserInfoRestTemplate();
                this.authoritiesExtractor = (AuthoritiesExtractor)authoritiesExtractor.getIfAvailable();
                this.principalExtractor = (PrincipalExtractor)principalExtractor.getIfAvailable();
            }

            @Bean
            @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
            public UserInfoTokenServices userInfoTokenServices() {
                UserInfoTokenServices services = new UserInfoTokenServices(this.sso.getUserInfoUri(), this.sso.getClientId());
                services.setRestTemplate(this.restTemplate);
                services.setTokenType(this.sso.getTokenType());
                if (this.authoritiesExtractor != null) {
                    services.setAuthoritiesExtractor(this.authoritiesExtractor);
                }
                if (this.principalExtractor != null) {
                    services.setPrincipalExtractor(this.principalExtractor);
                }
                return services;
            }
        }

        @Configuration
        @ConditionalOnClass(value={OAuth2ConnectionFactory.class})
        @Conditional(value={NotTokenInfoCondition.class})
        protected static class SocialTokenServicesConfiguration {
            private final ResourceServerProperties sso;
            private final OAuth2ConnectionFactory<?> connectionFactory;
            private final OAuth2RestOperations restTemplate;
            private final AuthoritiesExtractor authoritiesExtractor;
            private final PrincipalExtractor principalExtractor;

            public SocialTokenServicesConfiguration(ResourceServerProperties sso, ObjectProvider<OAuth2ConnectionFactory<?>> connectionFactory, UserInfoRestTemplateFactory restTemplateFactory, ObjectProvider<AuthoritiesExtractor> authoritiesExtractor, ObjectProvider<PrincipalExtractor> principalExtractor) {
                this.sso = sso;
                this.connectionFactory = (OAuth2ConnectionFactory)connectionFactory.getIfAvailable();
                this.restTemplate = restTemplateFactory.getUserInfoRestTemplate();
                this.authoritiesExtractor = (AuthoritiesExtractor)authoritiesExtractor.getIfAvailable();
                this.principalExtractor = (PrincipalExtractor)principalExtractor.getIfAvailable();
            }

            @Bean
            @ConditionalOnBean(value={ConnectionFactoryLocator.class})
            @ConditionalOnMissingBean(value={ResourceServerTokenServices.class})
            public SpringSocialTokenServices socialTokenServices() {
                return new SpringSocialTokenServices(this.connectionFactory, this.sso.getClientId());
            }

            @Bean
            @ConditionalOnMissingBean(value={ConnectionFactoryLocator.class, ResourceServerTokenServices.class})
            public UserInfoTokenServices userInfoTokenServices() {
                UserInfoTokenServices services = new UserInfoTokenServices(this.sso.getUserInfoUri(), this.sso.getClientId());
                services.setTokenType(this.sso.getTokenType());
                services.setRestTemplate(this.restTemplate);
                if (this.authoritiesExtractor != null) {
                    services.setAuthoritiesExtractor(this.authoritiesExtractor);
                }
                if (this.principalExtractor != null) {
                    services.setPrincipalExtractor(this.principalExtractor);
                }
                return services;
            }
        }

        @Configuration
        @Conditional(value={TokenInfoCondition.class})
        protected static class TokenInfoServicesConfiguration {
            private final ResourceServerProperties resource;

            protected TokenInfoServicesConfiguration(ResourceServerProperties resource) {
                this.resource = resource;
            }

            @Bean
            public RemoteTokenServices remoteTokenServices() {
                RemoteTokenServices services = new RemoteTokenServices();
                services.setCheckTokenEndpointUrl(this.resource.getTokenInfoUri());
                services.setClientId(this.resource.getClientId());
                services.setClientSecret(this.resource.getClientSecret());
                return services;
            }
        }
    }
}

