/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.requestreply;

import java.math.BigInteger;
import java.util.Arrays;
import org.springframework.util.Assert;

public final class CorrelationKey {
    private final byte[] correlationId;
    private volatile Integer hashCode;

    public CorrelationKey(byte[] correlationId) {
        Assert.notNull((Object)correlationId, (String)"'correlationId' cannot be null");
        this.correlationId = correlationId;
    }

    public byte[] getCorrelationId() {
        return this.correlationId;
    }

    public int hashCode() {
        if (this.hashCode != null) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.correlationId);
        this.hashCode = result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrelationKey other = (CorrelationKey)obj;
        return Arrays.equals(this.correlationId, other.correlationId);
    }

    public String toString() {
        return "[" + new BigInteger(this.correlationId) + "]";
    }
}

