/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.Assert;

public class DeadLetterPublishingRecoverer
implements BiConsumer<ConsumerRecord<?, ?>, Exception> {
    private static final Log logger = LogFactory.getLog(DeadLetterPublishingRecoverer.class);
    private final KafkaTemplate<Object, Object> template;
    private final boolean transactional;
    private final BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver;

    public DeadLetterPublishingRecoverer(KafkaTemplate<Object, Object> template) {
        this(template, (cr, e) -> new TopicPartition(cr.topic() + ".DLT", cr.partition()));
    }

    public DeadLetterPublishingRecoverer(KafkaTemplate<Object, Object> template, BiFunction<ConsumerRecord<?, ?>, Exception, TopicPartition> destinationResolver) {
        Assert.notNull(template, (String)"The template cannot be null");
        Assert.notNull(destinationResolver, (String)"The destinationResolver cannot be null");
        this.template = template;
        this.transactional = template.isTransactional();
        this.destinationResolver = destinationResolver;
    }

    @Override
    public void accept(ConsumerRecord<?, ?> record, Exception exception) {
        TopicPartition tp = this.destinationResolver.apply(record, exception);
        RecordHeaders headers = new RecordHeaders(record.headers().toArray());
        this.enhanceHeaders(headers, record, exception);
        ProducerRecord<Object, Object> outRecord = this.createProducerRecord(record, tp, headers);
        if (this.transactional && !this.template.inTransaction()) {
            this.template.executeInTransaction(t -> {
                this.publish(outRecord, t);
                return null;
            });
        } else {
            this.publish(outRecord, this.template);
        }
    }

    protected ProducerRecord<Object, Object> createProducerRecord(ConsumerRecord<?, ?> record, TopicPartition topicPartition, RecordHeaders headers) {
        return new ProducerRecord(topicPartition.topic(), topicPartition.partition() < 0 ? null : Integer.valueOf(topicPartition.partition()), record.key(), record.value(), (Iterable)headers);
    }

    private void publish(ProducerRecord<Object, Object> outRecord, KafkaOperations<Object, Object> template) {
        try {
            template.send(outRecord).addCallback(result -> {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successful dead-letter publication: " + result));
                }
            }, ex -> logger.error((Object)("Dead-letter publication failed for: " + outRecord), ex));
        }
        catch (Exception e) {
            logger.error((Object)("Dead-letter publication failed for: " + outRecord), (Throwable)e);
        }
    }

    private void enhanceHeaders(RecordHeaders kafkaHeaders, ConsumerRecord<?, ?> record, Exception exception) {
        kafkaHeaders.add((Header)new RecordHeader("kafka_dlt-original-topic", record.topic().getBytes(StandardCharsets.UTF_8)));
        kafkaHeaders.add((Header)new RecordHeader("kafka_dlt-original-partition", ByteBuffer.allocate(4).putInt(record.partition()).array()));
        kafkaHeaders.add((Header)new RecordHeader("kafka_dlt-original-offset", ByteBuffer.allocate(8).putLong(record.offset()).array()));
        kafkaHeaders.add((Header)new RecordHeader("kafka_dlt-original-timestamp", ByteBuffer.allocate(8).putLong(record.timestamp()).array()));
        kafkaHeaders.add((Header)new RecordHeader("kafka_dlt-original-timestamp-type", record.timestampType().toString().getBytes(StandardCharsets.UTF_8)));
        kafkaHeaders.add((Header)new RecordHeader("kafka_dlt-exception-fqcn", exception.getClass().getName().getBytes(StandardCharsets.UTF_8)));
        kafkaHeaders.add((Header)new RecordHeader("kafka_dlt-exception-message", exception.getMessage().getBytes(StandardCharsets.UTF_8)));
        kafkaHeaders.add((Header)new RecordHeader("kafka_dlt-exception-stacktrace", this.getStackTraceAsString(exception).getBytes(StandardCharsets.UTF_8)));
    }

    private String getStackTraceAsString(Throwable cause) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        cause.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }
}

