/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.AsteriskFromTable;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;

public class Table
extends AbstractSegment {
    private final SqlIdentifier name;

    Table(String name) {
        super(new Segment[0]);
        this.name = SqlIdentifier.unquoted(name);
    }

    Table(SqlIdentifier name) {
        super(new Segment[0]);
        this.name = name;
    }

    public static Table create(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        return new Table(name);
    }

    public static Table create(SqlIdentifier name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return new Table(name);
    }

    public static Table aliased(String name, String alias) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        Assert.hasText((String)alias, (String)"Alias must not be null or empty!");
        return new AliasedTable(name, alias);
    }

    public Table as(String alias) {
        Assert.hasText((String)alias, (String)"Alias must not be null or empty!");
        return new AliasedTable(this.name, SqlIdentifier.unquoted(alias));
    }

    public Table as(SqlIdentifier alias) {
        Assert.notNull((Object)alias, (String)"Alias must not be null");
        return new AliasedTable(this.name, alias);
    }

    public Column column(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        return new Column(name, this);
    }

    public Column column(SqlIdentifier name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        return new Column(name, this);
    }

    public List<Column> columns(String ... names) {
        Assert.notNull((Object)names, (String)"Names must not be null");
        return this.columns(Arrays.asList(names));
    }

    public List<Column> columns(SqlIdentifier ... names) {
        Assert.notNull((Object)names, (String)"Names must not be null");
        ArrayList<Column> columns = new ArrayList<Column>();
        for (SqlIdentifier name : names) {
            columns.add(this.column(name));
        }
        return columns;
    }

    public List<Column> columns(Collection<String> names) {
        Assert.notNull(names, (String)"Names must not be null");
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String name : names) {
            columns.add(this.column(name));
        }
        return columns;
    }

    public AsteriskFromTable asterisk() {
        return new AsteriskFromTable(this);
    }

    public SqlIdentifier getName() {
        return this.name;
    }

    public SqlIdentifier getReferenceName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    static class AliasedTable
    extends Table
    implements Aliased {
        private final SqlIdentifier alias;

        AliasedTable(String name, String alias) {
            super(name);
            Assert.hasText((String)alias, (String)"Alias must not be null or empty");
            this.alias = SqlIdentifier.unquoted(alias);
        }

        AliasedTable(SqlIdentifier name, SqlIdentifier alias) {
            super(name);
            Assert.notNull((Object)alias, (String)"Alias must not be null");
            this.alias = alias;
        }

        @Override
        public SqlIdentifier getAlias() {
            return this.alias;
        }

        @Override
        public SqlIdentifier getReferenceName() {
            return this.getAlias();
        }

        @Override
        public String toString() {
            return this.getName() + " AS " + this.getAlias();
        }
    }
}

