/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.DefaultAggregateChange;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public interface MutableAggregateChange<T>
extends AggregateChange<T> {
    public static <T> MutableAggregateChange<T> forSave(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return new DefaultAggregateChange<T>(AggregateChange.Kind.SAVE, ClassUtils.getUserClass(entity), entity);
    }

    public static <T> MutableAggregateChange<T> forDelete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null");
        return MutableAggregateChange.forDelete(ClassUtils.getUserClass(entity), entity);
    }

    public static <T> MutableAggregateChange<T> forDelete(Class<T> entityClass, @Nullable T entity) {
        Assert.notNull(entityClass, (String)"Entity class must not be null");
        return new DefaultAggregateChange<T>(AggregateChange.Kind.DELETE, entityClass, entity);
    }

    public void addAction(DbAction<?> var1);

    public void setEntity(@Nullable T var1);
}

