/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.Map;
import org.elasticsearch.index.query.QueryBuilder;
import org.springframework.data.elasticsearch.core.query.AliasQuery;

public class AliasBuilder {
    private String indexName;
    private String aliasName;
    private QueryBuilder filterBuilder;
    private Map<String, Object> filter;
    private String searchRouting;
    private String indexRouting;
    private String routing;

    public AliasBuilder withIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public AliasBuilder withAliasName(String aliasName) {
        this.aliasName = aliasName;
        return this;
    }

    public AliasBuilder withFilterBuilder(QueryBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public AliasBuilder withFilter(Map<String, Object> filter) {
        this.filter = filter;
        return this;
    }

    public AliasBuilder withSearchRouting(String searchRouting) {
        this.searchRouting = searchRouting;
        return this;
    }

    public AliasBuilder withIndexRouting(String indexRouting) {
        this.indexRouting = indexRouting;
        return this;
    }

    public AliasBuilder withRouting(String routing) {
        this.routing = routing;
        return this;
    }

    public AliasQuery build() {
        AliasQuery aliasQuery = new AliasQuery();
        aliasQuery.setIndexName(this.indexName);
        aliasQuery.setAliasName(this.aliasName);
        aliasQuery.setFilterBuilder(this.filterBuilder);
        aliasQuery.setFilter(this.filter);
        aliasQuery.setSearchRouting(this.searchRouting);
        aliasQuery.setIndexRouting(this.indexRouting);
        aliasQuery.setRouting(this.routing);
        return aliasQuery;
    }
}

