/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BindingCleaner;
import org.springframework.cloud.stream.binder.rabbit.RabbitAdminException;
import org.springframework.cloud.stream.binder.rabbit.RabbitManagementUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RabbitBindingCleaner
implements BindingCleaner {
    private static final Log logger = LogFactory.getLog(RabbitBindingCleaner.class);
    private static final String PREFIX_DELIMITER = ".";
    public static final String BINDER_PREFIX = "binder.";

    public Map<String, List<String>> clean(String entity, boolean isJob) {
        return this.clean("http://localhost:15672", "guest", "guest", "/", BINDER_PREFIX, entity, isJob);
    }

    public Map<String, List<String>> clean(String adminUri, String user, String pw, String vhost, String binderPrefix, String entity, boolean isJob) {
        return this.doClean(adminUri == null ? "http://localhost:15672" : adminUri, user == null ? "guest" : user, pw == null ? "guest" : pw, vhost == null ? "/" : vhost, binderPrefix == null ? BINDER_PREFIX : binderPrefix, entity, isJob);
    }

    private Map<String, List<String>> doClean(String adminUri, String user, String pw, String vhost, String binderPrefix, String entity, boolean isJob) {
        RestTemplate restTemplate = RabbitManagementUtils.buildRestTemplate(adminUri, user, pw);
        List<String> removedQueues = isJob ? null : this.findStreamQueues(adminUri, vhost, binderPrefix, entity, restTemplate);
        List<String> removedExchanges = this.findExchanges(adminUri, vhost, binderPrefix, entity, restTemplate);
        for (int i = removedQueues.size() - 1; i >= 0; --i) {
            String queueName = removedQueues.get(i);
            URI uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"queues", "{vhost}", "{stream}"}).buildAndExpand(new Object[]{vhost, queueName}).encode().toUri();
            restTemplate.delete(uri);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("deleted queue: " + queueName));
        }
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        if (removedQueues.size() > 0) {
            results.put("queues", removedQueues);
        }
        for (String exchange : removedExchanges) {
            URI uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"exchanges", "{vhost}", "{name}"}).buildAndExpand(new Object[]{vhost, exchange}).encode().toUri();
            restTemplate.delete(uri);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("deleted exchange: " + exchange));
        }
        if (removedExchanges.size() > 0) {
            results.put("exchanges", removedExchanges);
        }
        return results;
    }

    private List<String> findStreamQueues(String adminUri, String vhost, String binderPrefix, String stream, RestTemplate restTemplate) {
        String queueNamePrefix = this.adjustPrefix(AbstractBinder.applyPrefix((String)binderPrefix, (String)stream));
        List<Map<String, Object>> queues = this.listAllQueues(adminUri, vhost, restTemplate);
        ArrayList<String> removedQueues = new ArrayList<String>();
        for (Map<String, Object> queue : queues) {
            String queueName = (String)queue.get("name");
            if (!queueName.startsWith(queueNamePrefix)) continue;
            this.checkNoConsumers(queueName, queue);
            removedQueues.add(queueName);
        }
        return removedQueues;
    }

    private List<Map<String, Object>> listAllQueues(String adminUri, String vhost, RestTemplate restTemplate) {
        URI uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"queues", "{vhost}"}).buildAndExpand(new Object[]{vhost}).encode().toUri();
        List queues = (List)restTemplate.getForObject(uri, List.class);
        return queues;
    }

    private String adjustPrefix(String prefix) {
        if (prefix.endsWith("*")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix + PREFIX_DELIMITER;
    }

    private void checkNoConsumers(String queueName, Map<String, Object> queue) {
        if (!queue.get("consumers").equals(0)) {
            throw new RabbitAdminException("Queue " + queueName + " is in use");
        }
    }

    private List<String> findExchanges(String adminUri, String vhost, String binderPrefix, String entity, RestTemplate restTemplate) {
        ArrayList<String> removedExchanges = new ArrayList<String>();
        URI uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"exchanges", "{vhost}"}).buildAndExpand(new Object[]{vhost}).encode().toUri();
        List exchanges = (List)restTemplate.getForObject(uri, List.class);
        String exchangeNamePrefix = this.adjustPrefix(AbstractBinder.applyPrefix((String)binderPrefix, (String)entity));
        for (Map exchange : exchanges) {
            String exchangeName = (String)exchange.get("name");
            if (!exchangeName.startsWith(exchangeNamePrefix)) continue;
            uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"exchanges", "{vhost}", "{name}", "bindings", "source"}).buildAndExpand(new Object[]{vhost, exchangeName}).encode().toUri();
            List bindings = (List)restTemplate.getForObject(uri, List.class);
            if (this.hasNoForeignBindings(bindings, exchangeNamePrefix)) {
                uri = UriComponentsBuilder.fromUriString((String)(adminUri + "/api")).pathSegment(new String[]{"exchanges", "{vhost}", "{name}", "bindings", "destination"}).buildAndExpand(new Object[]{vhost, exchangeName}).encode().toUri();
                bindings = (List)restTemplate.getForObject(uri, List.class);
                if (bindings.size() == 0) {
                    removedExchanges.add((String)exchange.get("name"));
                    continue;
                }
                throw new RabbitAdminException("Cannot delete exchange " + exchangeName + "; it is a destination: " + bindings);
            }
            throw new RabbitAdminException("Cannot delete exchange " + exchangeName + "; it has bindings: " + bindings);
        }
        return removedExchanges;
    }

    private boolean hasNoForeignBindings(List<Map<String, Object>> bindings, String exchangeNamePrefix) {
        if (bindings.size() == 0) {
            return true;
        }
        boolean noForeign = true;
        for (Map<String, Object> binding : bindings) {
            if ("queue".equals(binding.get("destination_type")) && ((String)binding.get("destination")).startsWith(exchangeNamePrefix)) continue;
            noForeign = false;
            break;
        }
        return noForeign;
    }
}

