/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.hystrix;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.netflix.hystrix.ReactiveHystrixCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux", "com.netflix.hystrix.Hystrix"})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.hystrix.enabled"}, matchIfMissing=true)
public class ReactiveHystrixCircuitBreakerAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<ReactiveHystrixCircuitBreakerFactory>> customizers = new ArrayList<Customizer<ReactiveHystrixCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={ReactiveCircuitBreakerFactory.class})
    public ReactiveHystrixCircuitBreakerFactory reactiveHystrixCircuitBreakerFactory() {
        ReactiveHystrixCircuitBreakerFactory factory = new ReactiveHystrixCircuitBreakerFactory();
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }
}

