/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.endpoint;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ConfigurationProperties(prefix="endpoints.refresh", ignoreUnknownFields=false)
@ManagedResource
public class RefreshEndpoint
extends AbstractEndpoint<Collection<String>> {
    private ContextRefresher contextRefresher;

    public RefreshEndpoint(ContextRefresher contextRefresher) {
        super("refresh");
        this.contextRefresher = contextRefresher;
    }

    @ManagedOperation
    public String[] refresh() {
        Set<String> keys = this.contextRefresher.refresh();
        return keys.toArray(new String[keys.size()]);
    }

    public Collection<String> invoke() {
        return Arrays.asList(this.refresh());
    }
}

