/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.util.Objects;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;
import org.springframework.util.Assert;

public final class Binding {
    private final String value;

    private Binding(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)obj;
        return Objects.equals(this.value, binding.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    public static Binding of(String value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return new Binding(value);
    }

    public static Binding from(VolumeName sourceVolume, String destination) {
        Assert.notNull((Object)sourceVolume, (String)"SourceVolume must not be null");
        return Binding.from(sourceVolume.toString(), destination);
    }

    public static Binding from(String source, String destination) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)destination, (String)"Destination must not be null");
        return new Binding(source + ":" + destination);
    }
}

