/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.reactive.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.HandlerFilterFunction;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

@Deprecated
public class RouterFunctionMetrics {
    private final MeterRegistry registry;
    private final BiFunction<ServerRequest, ServerResponse, Iterable<Tag>> defaultTags;

    public RouterFunctionMetrics(MeterRegistry registry) {
        Assert.notNull((Object)registry, (String)"Registry must not be null");
        this.registry = registry;
        this.defaultTags = this::defaultTags;
    }

    private RouterFunctionMetrics(MeterRegistry registry, BiFunction<ServerRequest, ServerResponse, Iterable<Tag>> defaultTags) {
        Assert.notNull((Object)registry, (String)"Registry must not be null");
        Assert.notNull(defaultTags, (String)"DefaultTags must not be null");
        this.registry = registry;
        this.defaultTags = defaultTags;
    }

    private Iterable<Tag> defaultTags(ServerRequest request, ServerResponse response) {
        if (response == null) {
            return Tags.of((Tag[])new Tag[]{RouterFunctionMetrics.getMethodTag(request)});
        }
        return Tags.of((Tag[])new Tag[]{RouterFunctionMetrics.getMethodTag(request), RouterFunctionMetrics.getStatusTag(response)});
    }

    public RouterFunctionMetrics defaultTags(BiFunction<ServerRequest, ServerResponse, Iterable<Tag>> defaultTags) {
        return new RouterFunctionMetrics(this.registry, defaultTags);
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name) {
        return this.timer(name, (Iterable<Tag>)Tags.empty());
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name, String ... tags) {
        return this.timer(name, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public HandlerFilterFunction<ServerResponse, ServerResponse> timer(String name, Iterable<Tag> tags) {
        return new MetricsFilter(name, Tags.of(tags));
    }

    public static Tag getMethodTag(ServerRequest request) {
        return Tag.of((String)"method", (String)request.method().toString());
    }

    public static Tag getStatusTag(ServerResponse response) {
        return Tag.of((String)"status", (String)response.statusCode().toString());
    }

    private class MetricsFilter
    implements HandlerFilterFunction<ServerResponse, ServerResponse> {
        private final String name;
        private final Tags tags;

        MetricsFilter(String name, Tags tags) {
            this.name = name;
            this.tags = tags;
        }

        public Mono<ServerResponse> filter(ServerRequest request, HandlerFunction<ServerResponse> next) {
            long start = System.nanoTime();
            return next.handle(request).doOnSuccess(response -> this.timer(start, request, (ServerResponse)response)).doOnError(error -> this.timer(start, request, null));
        }

        private Iterable<Tag> getDefaultTags(ServerRequest request, ServerResponse response) {
            return (Iterable)RouterFunctionMetrics.this.defaultTags.apply(request, response);
        }

        private void timer(long start, ServerRequest request, ServerResponse response) {
            Tags allTags = this.tags.and(this.getDefaultTags(request, response));
            RouterFunctionMetrics.this.registry.timer(this.name, (Iterable)allTags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

