/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.ServiceLevelAgreementBoundary;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertiesMeterFilter
implements MeterFilter {
    private static final ServiceLevelAgreementBoundary[] EMPTY_SLA = new ServiceLevelAgreementBoundary[0];
    private MetricsProperties properties;

    public PropertiesMeterFilter(MetricsProperties properties) {
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.properties = properties;
    }

    public MeterFilterReply accept(Meter.Id id) {
        boolean enabled = this.lookup(this.properties.getEnable(), id, true);
        return enabled ? MeterFilterReply.NEUTRAL : MeterFilterReply.DENY;
    }

    public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
        MetricsProperties.Distribution distribution = this.properties.getDistribution();
        return DistributionStatisticConfig.builder().percentilesHistogram((Boolean)this.lookup(distribution.getPercentilesHistogram(), id, null)).percentiles((double[])this.lookup(distribution.getPercentiles(), id, null)).sla(this.convertSla(id.getType(), this.lookup(distribution.getSla(), id, null))).build().merge(config);
    }

    private long[] convertSla(Meter.Type meterType, ServiceLevelAgreementBoundary[] sla) {
        long[] converted = Arrays.stream(sla != null ? sla : EMPTY_SLA).map(candidate -> candidate.getValue(meterType)).filter(Objects::nonNull).mapToLong(Long::longValue).toArray();
        return (long[])(converted.length != 0 ? converted : null);
    }

    private <T> T lookup(Map<String, T> values, Meter.Id id, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        String name = id.getName();
        while (StringUtils.hasLength((String)name)) {
            T result = values.get(name);
            if (result != null) {
                return result;
            }
            int lastDot = name.lastIndexOf(46);
            name = lastDot != -1 ? name.substring(0, lastDot) : "";
        }
        return values.getOrDefault("all", defaultValue);
    }
}

