/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Arrays;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilderSupport;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.util.Assert;

public final class MessageBuilder
extends MessageBuilderSupport<Message> {
    private final byte[] body;

    public static MessageBuilder withBody(byte[] body) {
        Assert.notNull((Object)body, (String)"'body' cannot be null");
        return new MessageBuilder(body);
    }

    public static MessageBuilder withClonedBody(byte[] body) {
        Assert.notNull((Object)body, (String)"'body' cannot be null");
        return new MessageBuilder(Arrays.copyOf(body, body.length));
    }

    public static MessageBuilder withBody(byte[] body, int from, int to) {
        Assert.notNull((Object)body, (String)"'body' cannot be null");
        return new MessageBuilder(Arrays.copyOfRange(body, from, to));
    }

    public static MessageBuilder fromMessage(Message message) {
        Assert.notNull((Object)message, (String)"'message' cannot be null");
        return new MessageBuilder(message);
    }

    public static MessageBuilder fromClonedMessage(Message message) {
        Assert.notNull((Object)message, (String)"'message' cannot be null");
        byte[] body = message.getBody();
        Assert.notNull((Object)body, (String)"'body' cannot be null");
        return new MessageBuilder(Arrays.copyOf(body, body.length), message.getMessageProperties());
    }

    private MessageBuilder(byte[] body) {
        this.body = body;
    }

    private MessageBuilder(Message message) {
        this(message.getBody(), message.getMessageProperties());
    }

    private MessageBuilder(byte[] body, MessageProperties properties) {
        this.body = body;
        this.copyProperties(properties);
    }

    public MessageBuilder andProperties(MessageProperties properties) {
        this.setProperties(properties);
        return this;
    }

    @Override
    public Message build() {
        return new Message(this.body, this.buildProperties());
    }
}

