/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.exceptions.stacktrace;

import org.mockito.exceptions.stacktrace.StackTraceCleaner;

public class DefaultStackTraceCleaner
implements StackTraceCleaner {
    @Override
    public boolean isIn(StackTraceElement e) {
        return this.isIn(e.getClassName());
    }

    @Override
    public boolean isIn(StackTraceCleaner.StackFrameMetadata e) {
        return this.isIn(e.getClassName());
    }

    private boolean isIn(String className) {
        if (DefaultStackTraceCleaner.isFromMockitoRunner(className) || DefaultStackTraceCleaner.isFromMockitoRule(className)) {
            return true;
        }
        return !DefaultStackTraceCleaner.isMockDispatcher(className) && !DefaultStackTraceCleaner.isFromMockito(className) && !DefaultStackTraceCleaner.isMethodHandle(className);
    }

    private static boolean isMethodHandle(String className) {
        return className.startsWith("java.lang.invoke.MethodHandle");
    }

    private static boolean isMockDispatcher(String className) {
        return className.contains("$$EnhancerByMockitoWithCGLIB$$") || className.contains("$MockitoMock$");
    }

    private static boolean isFromMockito(String className) {
        return className.startsWith("org.mockito.");
    }

    private static boolean isFromMockitoRule(String className) {
        return className.startsWith("org.mockito.internal.junit.JUnitRule");
    }

    private static boolean isFromMockitoRunner(String className) {
        return className.startsWith("org.mockito.internal.runners.") || className.startsWith("org.mockito.runners.") || className.startsWith("org.mockito.junit.");
    }
}

