/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet.buffer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mariadb.jdbc.internal.common.packet.RawPacket;

public final class ReadUtil {
    private ReadUtil() {
    }

    public static void readFully(InputStream stream, byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new AssertionError((Object)"len < 0");
        }
        int remaining = len;
        while (remaining > 0) {
            int count = stream.read(b, off, remaining);
            if (count <= 0) {
                throw new EOFException("unexpected end of stream, read " + (len - remaining) + " bytes from " + len);
            }
            remaining -= count;
            off += count;
        }
    }

    public static void readFully(InputStream stream, byte[] b) throws IOException {
        ReadUtil.readFully(stream, b, 0, b.length);
    }

    public static boolean eofIsNext(RawPacket rawPacket) {
        ByteBuffer buf = rawPacket.getByteBuffer();
        return buf.get(0) == -2 && buf.capacity() < 9;
    }

    public static boolean isErrorPacket(RawPacket rawPacket) {
        return rawPacket.getByteBuffer().get(0) == -1;
    }
}

