/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.incremental;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.incremental.ICReporter;

public class MavenICReporter
implements ICReporter {
    private static final String IC_LOG_LEVEL_PROPERTY_NAME = "kotlin.compiler.incremental.log.level";
    private static final String IC_LOG_LEVEL_NONE = "none";
    private static final String IC_LOG_LEVEL_INFO = "info";
    private static final String IC_LOG_LEVEL_DEBUG = "debug";
    @NotNull
    private final Set<File> compiledKotlinFiles = new HashSet<File>();

    public static MavenICReporter get(@NotNull Log log) {
        String logLevel = System.getProperty(IC_LOG_LEVEL_PROPERTY_NAME);
        if (logLevel == null) {
            logLevel = log.isDebugEnabled() ? IC_LOG_LEVEL_DEBUG : IC_LOG_LEVEL_NONE;
        }
        if (logLevel.equalsIgnoreCase(IC_LOG_LEVEL_INFO)) {
            return MavenICReporter.info(log);
        }
        if (logLevel.equalsIgnoreCase(IC_LOG_LEVEL_DEBUG)) {
            return MavenICReporter.debug(log);
        }
        if (!logLevel.equalsIgnoreCase(IC_LOG_LEVEL_NONE)) {
            log.warn((CharSequence)("Unknown incremental compilation log level '" + logLevel + "',possible values: " + IC_LOG_LEVEL_NONE + ", " + IC_LOG_LEVEL_INFO + ", " + IC_LOG_LEVEL_DEBUG));
        }
        return MavenICReporter.noLog();
    }

    private static MavenICReporter info(final @NotNull Log log) {
        return new MavenICReporter(){

            @Override
            protected boolean isLogEnabled() {
                return log.isInfoEnabled();
            }

            @Override
            protected void log(String str) {
                log.info((CharSequence)str);
            }
        };
    }

    private static MavenICReporter debug(final @NotNull Log log) {
        return new MavenICReporter(){

            @Override
            protected boolean isLogEnabled() {
                return log.isDebugEnabled();
            }

            @Override
            protected void log(String str) {
                log.debug((CharSequence)str);
            }
        };
    }

    private static MavenICReporter noLog() {
        return new MavenICReporter();
    }

    protected boolean isLogEnabled() {
        return false;
    }

    protected void log(String str) {
    }

    private MavenICReporter() {
    }

    public void report(Function0<String> getMessage) {
        if (this.isLogEnabled()) {
            this.log((String)getMessage.invoke());
        }
    }

    public void reportCompileIteration(Collection<? extends File> sourceFiles, ExitCode exitCode) {
        this.compiledKotlinFiles.addAll(sourceFiles);
        if (this.isLogEnabled()) {
            this.log("Kotlin compile iteration: " + this.pathsAsString(sourceFiles));
            this.log("Exit code: " + exitCode.toString());
        }
    }

    @NotNull
    public String pathsAsString(Iterable<? extends File> files) {
        return ICReporter.DefaultImpls.pathsAsString((ICReporter)this, files);
    }

    @NotNull
    public String pathsAsString(File ... files) {
        return ICReporter.DefaultImpls.pathsAsString((ICReporter)this, (File[])files);
    }

    @NotNull
    public Set<File> getCompiledKotlinFiles() {
        return this.compiledKotlinFiles;
    }
}

