/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.placeholder;

import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.StringUtils;

public class DefaultPlaceholderReplacer
implements PlaceholderReplacer {
    private final Map<String, String> placeholders;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final Pattern anyPlaceholderPattern;

    public DefaultPlaceholderReplacer(Map<String, String> placeholders, String placeholderPrefix, String placeholderSuffix) {
        this.placeholders = placeholders;
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        this.anyPlaceholderPattern = Pattern.compile(Pattern.quote(placeholderPrefix) + "(.+?)" + Pattern.quote(placeholderSuffix));
    }

    @Override
    public Map<String, String> getPlaceholderReplacements() {
        return this.placeholders;
    }

    @Override
    public String replacePlaceholders(String input) {
        String noPlaceholders = input;
        for (Map.Entry<String, String> placeholder : this.getPlaceholderReplacements().entrySet()) {
            String searchTerm = this.placeholderPrefix + placeholder.getKey() + this.placeholderSuffix;
            String value = placeholder.getValue() == null ? "" : placeholder.getValue();
            noPlaceholders = StringUtils.replace(noPlaceholders, searchTerm, value);
        }
        this.checkForUnmatchedPlaceholderExpression(noPlaceholders);
        return noPlaceholders;
    }

    private void checkForUnmatchedPlaceholderExpression(String input) {
        Matcher matcher = this.anyPlaceholderPattern.matcher(input);
        TreeSet<String> unmatchedPlaceHolderExpressions = new TreeSet<String>();
        while (matcher.find()) {
            unmatchedPlaceHolderExpressions.add(matcher.group());
        }
        if (!unmatchedPlaceHolderExpressions.isEmpty()) {
            throw new FlywayException("No value provided for placeholder expressions: " + StringUtils.collectionToCommaDelimitedString(unmatchedPlaceHolderExpressions) + ".  Check your configuration!");
        }
    }
}

