/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.migration.jdbc.JdbcMigration;
import org.flywaydb.core.api.resolver.MigrationExecutor;

public class JdbcMigrationExecutor
implements MigrationExecutor {
    private final JdbcMigration jdbcMigration;

    JdbcMigrationExecutor(JdbcMigration jdbcMigration) {
        this.jdbcMigration = jdbcMigration;
    }

    @Override
    public void execute(Connection connection) throws SQLException {
        try {
            this.jdbcMigration.migrate(connection);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }

    @Override
    public boolean executeInTransaction() {
        return true;
    }
}

