/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.errorhandler.Warning;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.sqlscript.FlywaySqlScriptException;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.ContextImpl;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.jdbc.Result;
import org.flywaydb.core.internal.util.line.Line;
import org.flywaydb.core.internal.util.line.LineReader;
import org.flywaydb.core.internal.util.line.PlaceholderReplacingLine;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public abstract class ExecutableSqlScript<C extends ContextImpl>
extends SqlScript<C> {
    private static final Log LOG = LogFactory.getLog(ExecutableSqlScript.class);
    protected final Configuration configuration;
    private final boolean mixed;
    private List<SqlStatement<C>> sqlStatements;
    private boolean transactionalStatementFound;
    private boolean nonTransactionalStatementFound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutableSqlScript(Configuration configuration, LoadableResource resource, boolean mixed, PlaceholderReplacer placeholderReplacer) {
        super(resource, placeholderReplacer);
        this.configuration = configuration;
        this.mixed = mixed;
        LOG.debug("Parsing " + resource.getFilename() + " ...");
        LineReader reader = null;
        try {
            reader = resource.loadAsString();
            this.sqlStatements = this.extractStatements(reader);
        }
        finally {
            IOUtils.close(reader);
        }
    }

    private List<SqlStatement<C>> extractStatements(LineReader reader) {
        Line line;
        ArrayList<SqlStatement<C>> statements = new ArrayList<SqlStatement<C>>();
        Delimiter nonStandardDelimiter = null;
        SqlStatementBuilder sqlStatementBuilder = this.createSqlStatementBuilder();
        while ((line = reader.readLine()) != null) {
            line = new PlaceholderReplacingLine(line, this.placeholderReplacer);
            String lineStr = line.getLine();
            if (sqlStatementBuilder.isEmpty() && !StringUtils.hasText(lineStr)) continue;
            if (!sqlStatementBuilder.hasNonCommentPart()) {
                Delimiter newDelimiter = sqlStatementBuilder.extractNewDelimiterFromLine(lineStr);
                if (newDelimiter != null) {
                    nonStandardDelimiter = newDelimiter;
                    continue;
                }
                if (nonStandardDelimiter != null) {
                    sqlStatementBuilder.setDelimiter(nonStandardDelimiter);
                }
            }
            try {
                sqlStatementBuilder.addLine(line);
            }
            catch (Exception e) {
                throw new FlywayException("Flyway parsing bug (" + e.getMessage() + ") at line " + line.getLineNumber() + ": " + lineStr, e);
            }
            if (sqlStatementBuilder.canDiscard()) {
                sqlStatementBuilder = this.createSqlStatementBuilder();
                continue;
            }
            if (!sqlStatementBuilder.isTerminated()) continue;
            this.addStatement(statements, sqlStatementBuilder);
            sqlStatementBuilder = this.createSqlStatementBuilder();
        }
        if (!sqlStatementBuilder.isEmpty() && sqlStatementBuilder.hasNonCommentPart()) {
            this.addStatement(statements, sqlStatementBuilder);
        }
        return statements;
    }

    @Override
    public boolean executeInTransaction() {
        return !this.nonTransactionalStatementFound;
    }

    @Override
    public List<SqlStatement<C>> getSqlStatements() {
        return this.sqlStatements;
    }

    @Override
    public void execute(JdbcTemplate jdbcTemplate) {
        for (int i = 0; i < this.getSqlStatements().size(); ++i) {
            SqlStatement<C> sqlStatement = this.getSqlStatements().get(i);
            String sql = sqlStatement.getSql();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing SQL: " + sql);
            }
            this.executeStatement(jdbcTemplate, sqlStatement);
        }
    }

    private void executeStatement(JdbcTemplate jdbcTemplate, SqlStatement<C> sqlStatement) {
        C context = this.createContext();
        try {
            List<Result> results = sqlStatement.execute(context, jdbcTemplate);
            this.printWarnings(context);
            this.handleResults(context, results);
        }
        catch (SQLException e) {
            this.printWarnings(context);
            this.handleException(e, sqlStatement, context);
        }
    }

    private void handleResults(C context, List<Result> results) {
        for (Result result : results) {
            long updateCount = result.getUpdateCount();
            if (updateCount == -1L) continue;
            this.handleUpdateCount(updateCount);
        }
    }

    private void handleUpdateCount(long updateCount) {
        LOG.debug("Update Count: " + updateCount);
    }

    protected void handleException(SQLException e, SqlStatement sqlStatement, C context) {
        throw new FlywaySqlScriptException(this.resource, sqlStatement, e);
    }

    protected C createContext() {
        return (C)new ContextImpl();
    }

    private void printWarnings(C context) {
        for (Warning warning : ((ContextImpl)context).getWarnings()) {
            if ("00000".equals(warning.getState())) {
                LOG.info("DB: " + warning.getMessage());
                continue;
            }
            LOG.warn("DB: " + warning.getMessage() + " (SQL State: " + warning.getState() + " - Error Code: " + warning.getCode() + ")");
        }
    }

    protected abstract SqlStatementBuilder createSqlStatementBuilder();

    private void addStatement(List<SqlStatement<C>> statements, SqlStatementBuilder sqlStatementBuilder) {
        SqlStatement sqlStatement = sqlStatementBuilder.getSqlStatement();
        statements.add(sqlStatement);
        if (sqlStatementBuilder.executeInTransaction()) {
            this.transactionalStatementFound = true;
        } else {
            this.nonTransactionalStatementFound = true;
        }
        if (!this.mixed && this.transactionalStatementFound && this.nonTransactionalStatementFound) {
            throw new FlywayException("Detected both transactional and non-transactional statements within the same migration (even though mixed is false). Offending statement found at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatementBuilder.executeInTransaction() ? "" : " [non-transactional]"));
        }
        LOG.debug("Found statement at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatementBuilder.executeInTransaction() ? "" : " [non-transactional]"));
    }
}

