/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasAuthenticationException;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CasRealm
extends AuthorizingRealm {
    public static final String DEFAULT_REMEMBER_ME_ATTRIBUTE_NAME = "longTermAuthenticationRequestTokenUsed";
    public static final String DEFAULT_VALIDATION_PROTOCOL = "CAS";
    private static Logger log = LoggerFactory.getLogger(CasRealm.class);
    private String casServerUrlPrefix;
    private String casService;
    private String validationProtocol = "CAS";
    private String rememberMeAttributeName = "longTermAuthenticationRequestTokenUsed";
    private TicketValidator ticketValidator;
    private String defaultRoles;
    private String defaultPermissions;
    private String roleAttributeNames;
    private String permissionAttributeNames;

    public CasRealm() {
        this.setAuthenticationTokenClass(CasToken.class);
    }

    protected void onInit() {
        super.onInit();
        this.ensureTicketValidator();
    }

    protected TicketValidator ensureTicketValidator() {
        if (this.ticketValidator == null) {
            this.ticketValidator = this.createTicketValidator();
        }
        return this.ticketValidator;
    }

    protected TicketValidator createTicketValidator() {
        String urlPrefix = this.getCasServerUrlPrefix();
        if ("saml".equalsIgnoreCase(this.getValidationProtocol())) {
            return new Saml11TicketValidator(urlPrefix);
        }
        return new Cas20ServiceTicketValidator(urlPrefix);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        CasToken casToken = (CasToken)token;
        if (token == null) {
            return null;
        }
        String ticket = (String)casToken.getCredentials();
        if (!StringUtils.hasText((String)ticket)) {
            return null;
        }
        TicketValidator ticketValidator = this.ensureTicketValidator();
        try {
            boolean isRemembered;
            Assertion casAssertion = ticketValidator.validate(ticket, this.getCasService());
            AttributePrincipal casPrincipal = casAssertion.getPrincipal();
            String userId = casPrincipal.getName();
            log.debug("Validate ticket : {} in CAS server : {} to retrieve user : {}", new Object[]{ticket, this.getCasServerUrlPrefix(), userId});
            Map attributes = casPrincipal.getAttributes();
            casToken.setUserId(userId);
            String rememberMeAttributeName = this.getRememberMeAttributeName();
            String rememberMeStringValue = (String)attributes.get(rememberMeAttributeName);
            boolean bl = isRemembered = rememberMeStringValue != null && Boolean.parseBoolean(rememberMeStringValue);
            if (isRemembered) {
                casToken.setRememberMe(true);
            }
            List principals = CollectionUtils.asList((Object[])new Object[]{userId, attributes});
            SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Collection)principals, this.getName());
            return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)ticket);
        }
        catch (TicketValidationException e) {
            throw new CasAuthenticationException("Unable to validate ticket [" + ticket + "]", e);
        }
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String value;
        SimplePrincipalCollection principalCollection = (SimplePrincipalCollection)principals;
        List listPrincipals = principalCollection.asList();
        Map attributes = (Map)listPrincipals.get(1);
        SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
        this.addRoles(simpleAuthorizationInfo, this.split(this.defaultRoles));
        this.addPermissions(simpleAuthorizationInfo, this.split(this.defaultPermissions));
        List<String> attributeNames = this.split(this.roleAttributeNames);
        for (String attributeName : attributeNames) {
            value = (String)attributes.get(attributeName);
            this.addRoles(simpleAuthorizationInfo, this.split(value));
        }
        attributeNames = this.split(this.permissionAttributeNames);
        for (String attributeName : attributeNames) {
            value = (String)attributes.get(attributeName);
            this.addPermissions(simpleAuthorizationInfo, this.split(value));
        }
        return simpleAuthorizationInfo;
    }

    private List<String> split(String s) {
        ArrayList<String> list = new ArrayList<String>();
        String[] elements = StringUtils.split((String)s, (char)',');
        if (elements != null && elements.length > 0) {
            for (String element : elements) {
                if (!StringUtils.hasText((String)element)) continue;
                list.add(element.trim());
            }
        }
        return list;
    }

    private void addRoles(SimpleAuthorizationInfo simpleAuthorizationInfo, List<String> roles) {
        for (String role : roles) {
            simpleAuthorizationInfo.addRole(role);
        }
    }

    private void addPermissions(SimpleAuthorizationInfo simpleAuthorizationInfo, List<String> permissions) {
        for (String permission : permissions) {
            simpleAuthorizationInfo.addStringPermission(permission);
        }
    }

    public String getCasServerUrlPrefix() {
        return this.casServerUrlPrefix;
    }

    public void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    public String getCasService() {
        return this.casService;
    }

    public void setCasService(String casService) {
        this.casService = casService;
    }

    public String getValidationProtocol() {
        return this.validationProtocol;
    }

    public void setValidationProtocol(String validationProtocol) {
        this.validationProtocol = validationProtocol;
    }

    public String getRememberMeAttributeName() {
        return this.rememberMeAttributeName;
    }

    public void setRememberMeAttributeName(String rememberMeAttributeName) {
        this.rememberMeAttributeName = rememberMeAttributeName;
    }

    public String getDefaultRoles() {
        return this.defaultRoles;
    }

    public void setDefaultRoles(String defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    public String getDefaultPermissions() {
        return this.defaultPermissions;
    }

    public void setDefaultPermissions(String defaultPermissions) {
        this.defaultPermissions = defaultPermissions;
    }

    public String getRoleAttributeNames() {
        return this.roleAttributeNames;
    }

    public void setRoleAttributeNames(String roleAttributeNames) {
        this.roleAttributeNames = roleAttributeNames;
    }

    public String getPermissionAttributeNames() {
        return this.permissionAttributeNames;
    }

    public void setPermissionAttributeNames(String permissionAttributeNames) {
        this.permissionAttributeNames = permissionAttributeNames;
    }
}

