/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.Preconditions;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class Types {
    private static final int NOT_SET = 0;

    public static MessageTypeBuilder buildMessage() {
        return new MessageTypeBuilder();
    }

    public static GroupBuilder<GroupType> buildGroup(Type.Repetition repetition) {
        return (GroupBuilder)new GroupBuilder(GroupType.class).repetition(repetition);
    }

    public static GroupBuilder<GroupType> requiredGroup() {
        return (GroupBuilder)new GroupBuilder(GroupType.class).repetition(Type.Repetition.REQUIRED);
    }

    public static GroupBuilder<GroupType> optionalGroup() {
        return (GroupBuilder)new GroupBuilder(GroupType.class).repetition(Type.Repetition.OPTIONAL);
    }

    public static GroupBuilder<GroupType> repeatedGroup() {
        return (GroupBuilder)new GroupBuilder(GroupType.class).repetition(Type.Repetition.REPEATED);
    }

    public static PrimitiveBuilder<PrimitiveType> primitive(PrimitiveType.PrimitiveTypeName type, Type.Repetition repetition) {
        return (PrimitiveBuilder)new PrimitiveBuilder(PrimitiveType.class, type).repetition(repetition);
    }

    public static PrimitiveBuilder<PrimitiveType> required(PrimitiveType.PrimitiveTypeName type) {
        return (PrimitiveBuilder)new PrimitiveBuilder(PrimitiveType.class, type).repetition(Type.Repetition.REQUIRED);
    }

    public static PrimitiveBuilder<PrimitiveType> optional(PrimitiveType.PrimitiveTypeName type) {
        return (PrimitiveBuilder)new PrimitiveBuilder(PrimitiveType.class, type).repetition(Type.Repetition.OPTIONAL);
    }

    public static PrimitiveBuilder<PrimitiveType> repeated(PrimitiveType.PrimitiveTypeName type) {
        return (PrimitiveBuilder)new PrimitiveBuilder(PrimitiveType.class, type).repetition(Type.Repetition.REPEATED);
    }

    public static class MessageTypeBuilder
    extends GroupBuilder<MessageType> {
        private MessageTypeBuilder() {
            super(MessageType.class);
            this.repetition(Type.Repetition.REQUIRED);
        }

        @Override
        public MessageType named(String name) {
            Preconditions.checkNotNull((Object)name, (String)"Name is required");
            return new MessageType(name, this.fields);
        }
    }

    public static class GroupBuilder<P>
    extends Builder<GroupBuilder<P>, P> {
        protected final List<Type> fields = new ArrayList<Type>();

        private GroupBuilder(P parent) {
            super(parent);
        }

        private GroupBuilder(Class<P> returnType) {
            super(returnType);
        }

        @Override
        protected GroupBuilder<P> self() {
            return this;
        }

        public PrimitiveBuilder<GroupBuilder<P>> primitive(PrimitiveType.PrimitiveTypeName type, Type.Repetition repetition) {
            return (PrimitiveBuilder)new PrimitiveBuilder(this, type).repetition(repetition);
        }

        public PrimitiveBuilder<GroupBuilder<P>> required(PrimitiveType.PrimitiveTypeName type) {
            return (PrimitiveBuilder)new PrimitiveBuilder(this, type).repetition(Type.Repetition.REQUIRED);
        }

        public PrimitiveBuilder<GroupBuilder<P>> optional(PrimitiveType.PrimitiveTypeName type) {
            return (PrimitiveBuilder)new PrimitiveBuilder(this, type).repetition(Type.Repetition.OPTIONAL);
        }

        public PrimitiveBuilder<GroupBuilder<P>> repeated(PrimitiveType.PrimitiveTypeName type) {
            return (PrimitiveBuilder)new PrimitiveBuilder(this, type).repetition(Type.Repetition.REPEATED);
        }

        public GroupBuilder<GroupBuilder<P>> group(Type.Repetition repetition) {
            return (GroupBuilder)new GroupBuilder<GroupBuilder>(this).repetition(repetition);
        }

        public GroupBuilder<GroupBuilder<P>> requiredGroup() {
            return (GroupBuilder)new GroupBuilder<GroupBuilder>(this).repetition(Type.Repetition.REQUIRED);
        }

        public GroupBuilder<GroupBuilder<P>> optionalGroup() {
            return (GroupBuilder)new GroupBuilder<GroupBuilder>(this).repetition(Type.Repetition.OPTIONAL);
        }

        public GroupBuilder<GroupBuilder<P>> repeatedGroup() {
            return (GroupBuilder)new GroupBuilder<GroupBuilder>(this).repetition(Type.Repetition.REPEATED);
        }

        public GroupBuilder<P> addField(Type type) {
            this.fields.add(type);
            return this;
        }

        public GroupBuilder<P> addFields(Type ... types) {
            for (Type type : types) {
                this.fields.add(type);
            }
            return this;
        }

        @Override
        protected GroupType build(String name) {
            Preconditions.checkState((!this.fields.isEmpty() ? 1 : 0) != 0, (String)"Cannot build an empty group");
            return new GroupType(this.repetition, name, this.originalType, this.fields, this.id);
        }
    }

    public static class PrimitiveBuilder<P>
    extends Builder<PrimitiveBuilder<P>, P> {
        private static final long MAX_PRECISION_INT32 = PrimitiveBuilder.maxPrecision(4);
        private static final long MAX_PRECISION_INT64 = PrimitiveBuilder.maxPrecision(8);
        private final PrimitiveType.PrimitiveTypeName primitiveType;
        private int length = 0;
        private int precision = 0;
        private int scale = 0;

        private PrimitiveBuilder(P parent, PrimitiveType.PrimitiveTypeName type) {
            super(parent);
            this.primitiveType = type;
        }

        private PrimitiveBuilder(Class<P> returnType, PrimitiveType.PrimitiveTypeName type) {
            super(returnType);
            this.primitiveType = type;
        }

        @Override
        protected PrimitiveBuilder<P> self() {
            return this;
        }

        public PrimitiveBuilder<P> length(int length) {
            this.length = length;
            return this;
        }

        public PrimitiveBuilder<P> precision(int precision) {
            this.precision = precision;
            return this;
        }

        public PrimitiveBuilder<P> scale(int scale) {
            this.scale = scale;
            return this;
        }

        @Override
        protected PrimitiveType build(String name) {
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY == this.primitiveType) {
                Preconditions.checkArgument((this.length > 0 ? 1 : 0) != 0, (String)("Invalid FIXED_LEN_BYTE_ARRAY length: " + this.length));
            }
            DecimalMetadata meta = this.decimalMetadata();
            if (this.originalType != null) {
                switch (this.originalType) {
                    case UTF8: 
                    case JSON: 
                    case BSON: {
                        Preconditions.checkState((this.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY ? 1 : 0) != 0, (String)(this.originalType.toString() + " can only annotate binary fields"));
                        break;
                    }
                    case DECIMAL: {
                        Preconditions.checkState((this.primitiveType == PrimitiveType.PrimitiveTypeName.INT32 || this.primitiveType == PrimitiveType.PrimitiveTypeName.INT64 || this.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY || this.primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY ? 1 : 0) != 0, (String)"DECIMAL can only annotate INT32, INT64, BINARY, and FIXED");
                        if (this.primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
                            Preconditions.checkState(((long)meta.getPrecision() <= MAX_PRECISION_INT32 ? 1 : 0) != 0, (String)("INT32 cannot store " + meta.getPrecision() + " digits " + "(max " + MAX_PRECISION_INT32 + ")"));
                            break;
                        }
                        if (this.primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                            Preconditions.checkState(((long)meta.getPrecision() <= MAX_PRECISION_INT64 ? 1 : 0) != 0, (String)("INT64 cannot store " + meta.getPrecision() + " digits " + "(max " + MAX_PRECISION_INT64 + ")"));
                            break;
                        }
                        if (this.primitiveType != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) break;
                        Preconditions.checkState(((long)meta.getPrecision() <= PrimitiveBuilder.maxPrecision(this.length) ? 1 : 0) != 0, (String)("FIXED(" + this.length + ") cannot store " + meta.getPrecision() + " digits (max " + PrimitiveBuilder.maxPrecision(this.length) + ")"));
                        break;
                    }
                    case DATE: 
                    case TIME_MILLIS: 
                    case UINT_8: 
                    case UINT_16: 
                    case UINT_32: 
                    case INT_8: 
                    case INT_16: 
                    case INT_32: {
                        Preconditions.checkState((this.primitiveType == PrimitiveType.PrimitiveTypeName.INT32 ? 1 : 0) != 0, (String)(this.originalType.toString() + " can only annotate INT32"));
                        break;
                    }
                    case TIMESTAMP_MILLIS: 
                    case UINT_64: 
                    case INT_64: {
                        Preconditions.checkState((this.primitiveType == PrimitiveType.PrimitiveTypeName.INT64 ? 1 : 0) != 0, (String)(this.originalType.toString() + " can only annotate INT64"));
                        break;
                    }
                    case INTERVAL: {
                        Preconditions.checkState((this.primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY && this.length == 12 ? 1 : 0) != 0, (String)"INTERVAL can only annotate FIXED_LEN_BYTE_ARRAY(12)");
                        break;
                    }
                    case ENUM: {
                        Preconditions.checkState((this.primitiveType == PrimitiveType.PrimitiveTypeName.BINARY ? 1 : 0) != 0, (String)"ENUM can only annotate binary fields");
                        break;
                    }
                    default: {
                        throw new IllegalStateException((Object)((Object)this.originalType) + " can not be applied to a primitive type");
                    }
                }
            }
            return new PrimitiveType(this.repetition, this.primitiveType, this.length, name, this.originalType, meta, this.id);
        }

        private static long maxPrecision(int numBytes) {
            return Math.round(Math.floor(Math.log10(Math.pow(2.0, 8 * numBytes - 1) - 1.0)));
        }

        protected DecimalMetadata decimalMetadata() {
            DecimalMetadata meta = null;
            if (OriginalType.DECIMAL == this.originalType) {
                Preconditions.checkArgument((this.precision > 0 ? 1 : 0) != 0, (String)("Invalid DECIMAL precision: " + this.precision));
                Preconditions.checkArgument((this.scale >= 0 ? 1 : 0) != 0, (String)("Invalid DECIMAL scale: " + this.scale));
                Preconditions.checkArgument((this.scale <= this.precision ? 1 : 0) != 0, (String)"Invalid DECIMAL scale: cannot be greater than precision");
                meta = new DecimalMetadata(this.precision, this.scale);
            }
            return meta;
        }
    }

    public static abstract class Builder<T extends Builder, P> {
        protected final P parent;
        protected final Class<? extends P> returnClass;
        protected Type.Repetition repetition = null;
        protected OriginalType originalType = null;
        protected Type.ID id = null;
        private boolean repetitionAlreadySet = false;

        protected Builder(P parent) {
            Preconditions.checkNotNull(parent, (String)"Parent cannot be null");
            this.parent = parent;
            this.returnClass = null;
        }

        protected Builder(Class<P> returnClass) {
            Preconditions.checkArgument((boolean)Type.class.isAssignableFrom(returnClass), (String)"The requested return class must extend Type");
            this.returnClass = returnClass;
            this.parent = null;
        }

        protected abstract T self();

        protected final T repetition(Type.Repetition repetition) {
            Preconditions.checkArgument((!this.repetitionAlreadySet ? 1 : 0) != 0, (String)"Repetition has already been set");
            Preconditions.checkNotNull((Object)((Object)repetition), (String)"Repetition cannot be null");
            this.repetition = repetition;
            this.repetitionAlreadySet = true;
            return this.self();
        }

        public T as(OriginalType type) {
            this.originalType = type;
            return this.self();
        }

        public T id(int id) {
            this.id = new Type.ID(id);
            return this.self();
        }

        protected abstract Type build(String var1);

        public P named(String name) {
            Preconditions.checkNotNull((Object)name, (String)"Name is required");
            Preconditions.checkNotNull((Object)((Object)this.repetition), (String)"Repetition is required");
            Type type = this.build(name);
            if (this.parent != null) {
                if (GroupBuilder.class.isAssignableFrom(this.parent.getClass())) {
                    ((GroupBuilder)GroupBuilder.class.cast(this.parent)).addField(type);
                }
                return this.parent;
            }
            return this.returnClass.cast(type);
        }
    }
}

