/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.pc.Concurrency;
import org.apache.maven.surefire.junitcore.pc.RunnerCounter;
import org.apache.maven.surefire.testset.TestSetFailedException;

final class ParallelComputerUtil {
    private static int availableProcessors = Runtime.getRuntime().availableProcessors();

    private ParallelComputerUtil() {
        throw new IllegalStateException("Suppresses calling constructor, ensuring non-instantiability.");
    }

    static void overrideAvailableProcessors(int availableProcessors) {
        ParallelComputerUtil.availableProcessors = availableProcessors;
    }

    static void setDefaultAvailableProcessors() {
        availableProcessors = Runtime.getRuntime().availableProcessors();
    }

    static Concurrency resolveConcurrency(JUnitCoreParameters params, RunnerCounter counts) throws TestSetFailedException {
        if (!params.isParallelismSelected()) {
            throw new TestSetFailedException("Unspecified parameter 'parallel'.");
        }
        if (!(params.isUseUnlimitedThreads().booleanValue() || ParallelComputerUtil.hasThreadCount(params) || ParallelComputerUtil.hasThreadCounts(params))) {
            throw new TestSetFailedException("Unspecified thread-count(s). See the parameters useUnlimitedThreads, threadcount, threadcountsuites, threadcountclasses, threadcountmethods.");
        }
        if (params.isUseUnlimitedThreads().booleanValue()) {
            return ParallelComputerUtil.concurrencyForUnlimitedThreads(params);
        }
        if (ParallelComputerUtil.hasThreadCount(params)) {
            if (ParallelComputerUtil.hasThreadCounts(params)) {
                return ParallelComputerUtil.isLeafUnspecified(params) ? ParallelComputerUtil.concurrencyFromAllThreadCountsButUnspecifiedLeafCount(params, counts) : ParallelComputerUtil.concurrencyFromAllThreadCounts(params);
            }
            return ParallelComputerUtil.estimateConcurrency(params, counts);
        }
        return ParallelComputerUtil.concurrencyFromThreadCounts(params);
    }

    private static Concurrency concurrencyForUnlimitedThreads(JUnitCoreParameters params) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? ParallelComputerUtil.threadCountSuites(params) : 0;
        concurrency.classes = params.isParallelClasses() ? ParallelComputerUtil.threadCountClasses(params) : 0;
        concurrency.methods = params.isParallelMethods() ? ParallelComputerUtil.threadCountMethods(params) : 0;
        concurrency.capacity = Integer.MAX_VALUE;
        return concurrency;
    }

    private static Concurrency estimateConcurrency(JUnitCoreParameters params, RunnerCounter counts) {
        Concurrency concurrency = new Concurrency();
        int parallelEntities = ParallelComputerUtil.countParallelEntities(params);
        concurrency.capacity = ParallelComputerUtil.multiplyByCoreCount(params, params.getThreadCount());
        if (parallelEntities == 1 || counts == null || counts.classes == 0L) {
            double ratio = 1.0 / (double)parallelEntities;
            int threads = ParallelComputerUtil.multiplyByCoreCount(params, ratio * (double)params.getThreadCount());
            concurrency.suites = params.isParallelSuites() ? ParallelComputerUtil.minSuites(threads, counts) : 0;
            concurrency.classes = params.isParallelClasses() ? ParallelComputerUtil.minClasses(threads, counts) : 0;
            int n = concurrency.methods = params.isParallelMethods() ? ParallelComputerUtil.minMethods(threads, counts) : 0;
            if (parallelEntities == 1) {
                concurrency.capacity = 0;
            } else {
                ParallelComputerUtil.adjustLeaf(params, concurrency);
            }
        } else {
            concurrency.suites = params.isParallelSuites() ? ParallelComputerUtil.toNonNegative(counts.suites) : 0;
            concurrency.classes = params.isParallelClasses() ? ParallelComputerUtil.toNonNegative(counts.classes) : 0;
            concurrency.methods = params.isParallelMethods() ? ParallelComputerUtil.toNonNegative(Math.ceil((double)counts.methods / (double)counts.classes)) : 0;
            double sum = ParallelComputerUtil.toNonNegative(concurrency.suites + concurrency.classes + concurrency.methods);
            if ((double)concurrency.capacity < sum && sum != 0.0) {
                double weight = (double)concurrency.capacity / sum;
                concurrency.suites = (int)((double)concurrency.suites * weight);
                concurrency.classes = (int)((double)concurrency.classes * weight);
                concurrency.methods = (int)((double)concurrency.methods * weight);
            }
            ParallelComputerUtil.adjustLeaf(params, concurrency);
        }
        return concurrency;
    }

    private static Concurrency concurrencyFromAllThreadCountsButUnspecifiedLeafCount(JUnitCoreParameters params, RunnerCounter counts) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? params.getThreadCountSuites() : 0;
        concurrency.suites = params.isParallelSuites() ? ParallelComputerUtil.multiplyByCoreCount(params, concurrency.suites) : 0;
        concurrency.classes = params.isParallelClasses() ? params.getThreadCountClasses() : 0;
        concurrency.classes = params.isParallelClasses() ? ParallelComputerUtil.multiplyByCoreCount(params, concurrency.classes) : 0;
        concurrency.methods = params.isParallelMethods() ? params.getThreadCountMethods() : 0;
        concurrency.methods = params.isParallelMethods() ? ParallelComputerUtil.multiplyByCoreCount(params, concurrency.methods) : 0;
        concurrency.capacity = ParallelComputerUtil.multiplyByCoreCount(params, params.getThreadCount());
        if (counts != null) {
            concurrency.suites = ParallelComputerUtil.toNonNegative(Math.min((long)concurrency.suites, counts.suites));
            concurrency.classes = ParallelComputerUtil.toNonNegative(Math.min((long)concurrency.classes, counts.classes));
        }
        ParallelComputerUtil.setLeafInfinite(params, concurrency);
        return concurrency;
    }

    private static Concurrency concurrencyFromAllThreadCounts(JUnitCoreParameters params) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? params.getThreadCountSuites() : 0;
        concurrency.classes = params.isParallelClasses() ? params.getThreadCountClasses() : 0;
        concurrency.methods = params.isParallelMethods() ? params.getThreadCountMethods() : 0;
        concurrency.capacity = params.getThreadCount();
        double all = ParallelComputerUtil.sumThreadCounts(concurrency);
        concurrency.suites = params.isParallelSuites() ? ParallelComputerUtil.multiplyByCoreCount(params, (double)concurrency.capacity * ((double)concurrency.suites / all)) : 0;
        concurrency.classes = params.isParallelClasses() ? ParallelComputerUtil.multiplyByCoreCount(params, (double)concurrency.capacity * ((double)concurrency.classes / all)) : 0;
        concurrency.methods = params.isParallelMethods() ? ParallelComputerUtil.multiplyByCoreCount(params, (double)concurrency.capacity * ((double)concurrency.methods / all)) : 0;
        concurrency.capacity = ParallelComputerUtil.multiplyByCoreCount(params, concurrency.capacity);
        ParallelComputerUtil.adjustPrecisionInLeaf(params, concurrency);
        return concurrency;
    }

    private static Concurrency concurrencyFromThreadCounts(JUnitCoreParameters params) {
        Concurrency concurrency = new Concurrency();
        concurrency.suites = params.isParallelSuites() ? ParallelComputerUtil.threadCountSuites(params) : 0;
        concurrency.classes = params.isParallelClasses() ? ParallelComputerUtil.threadCountClasses(params) : 0;
        concurrency.methods = params.isParallelMethods() ? ParallelComputerUtil.threadCountMethods(params) : 0;
        concurrency.capacity = ParallelComputerUtil.toNonNegative(ParallelComputerUtil.sumThreadCounts(concurrency));
        return concurrency;
    }

    private static int countParallelEntities(JUnitCoreParameters params) {
        int count = 0;
        if (params.isParallelSuites()) {
            ++count;
        }
        if (params.isParallelClasses()) {
            ++count;
        }
        if (params.isParallelMethods()) {
            ++count;
        }
        return count;
    }

    private static void adjustPrecisionInLeaf(JUnitCoreParameters params, Concurrency concurrency) {
        if (params.isParallelMethods()) {
            concurrency.methods = concurrency.capacity - concurrency.suites - concurrency.classes;
        } else if (params.isParallelClasses()) {
            concurrency.classes = concurrency.capacity - concurrency.suites;
        }
    }

    private static void adjustLeaf(JUnitCoreParameters params, Concurrency concurrency) {
        if (params.isParallelMethods()) {
            concurrency.methods = Integer.MAX_VALUE;
        } else if (params.isParallelClasses()) {
            concurrency.classes = Integer.MAX_VALUE;
        }
    }

    private static void setLeafInfinite(JUnitCoreParameters params, Concurrency concurrency) {
        if (params.isParallelMethods()) {
            concurrency.methods = Integer.MAX_VALUE;
        } else if (params.isParallelClasses()) {
            concurrency.classes = Integer.MAX_VALUE;
        } else if (params.isParallelSuites()) {
            concurrency.suites = Integer.MAX_VALUE;
        }
    }

    private static boolean isLeafUnspecified(JUnitCoreParameters params) {
        int maskOfParallel = params.isParallelSuites() ? 4 : 0;
        maskOfParallel |= params.isParallelClasses() ? 2 : 0;
        int maskOfConcurrency = params.getThreadCountSuites() > 0 ? 4 : 0;
        maskOfConcurrency |= params.getThreadCountClasses() > 0 ? 2 : 0;
        maskOfConcurrency |= params.getThreadCountMethods() > 0 ? 1 : 0;
        int leaf = Integer.lowestOneBit(maskOfParallel |= params.isParallelMethods() ? 1 : 0);
        return (maskOfConcurrency &= maskOfParallel) == maskOfParallel - leaf;
    }

    private static double sumThreadCounts(Concurrency concurrency) {
        double sum = concurrency.suites;
        sum += (double)concurrency.classes;
        return sum += (double)concurrency.methods;
    }

    private static boolean hasThreadCounts(JUnitCoreParameters jUnitCoreParameters) {
        return jUnitCoreParameters.isParallelSuites() && jUnitCoreParameters.getThreadCountSuites() > 0 || jUnitCoreParameters.isParallelClasses() && jUnitCoreParameters.getThreadCountClasses() > 0 || jUnitCoreParameters.isParallelMethods() && jUnitCoreParameters.getThreadCountMethods() > 0;
    }

    private static boolean hasThreadCount(JUnitCoreParameters jUnitCoreParameters) {
        return jUnitCoreParameters.getThreadCount() > 0;
    }

    private static int threadCountMethods(JUnitCoreParameters jUnitCoreParameters) {
        return ParallelComputerUtil.multiplyByCoreCount(jUnitCoreParameters, jUnitCoreParameters.getThreadCountMethods());
    }

    private static int threadCountClasses(JUnitCoreParameters jUnitCoreParameters) {
        return ParallelComputerUtil.multiplyByCoreCount(jUnitCoreParameters, jUnitCoreParameters.getThreadCountClasses());
    }

    private static int threadCountSuites(JUnitCoreParameters jUnitCoreParameters) {
        return ParallelComputerUtil.multiplyByCoreCount(jUnitCoreParameters, jUnitCoreParameters.getThreadCountSuites());
    }

    private static int multiplyByCoreCount(JUnitCoreParameters jUnitCoreParameters, double threadsPerCore) {
        double numberOfThreads = jUnitCoreParameters.isPerCoreThreadCount() != false ? threadsPerCore * (double)availableProcessors : threadsPerCore;
        return numberOfThreads > 0.0 ? ParallelComputerUtil.toNonNegative(numberOfThreads) : Integer.MAX_VALUE;
    }

    private static int minSuites(int threads, RunnerCounter counts) {
        long count = counts == null ? Integer.MAX_VALUE : counts.suites;
        return Math.min(threads, ParallelComputerUtil.toNonNegative(count));
    }

    private static int minClasses(int threads, RunnerCounter counts) {
        long count = counts == null ? Integer.MAX_VALUE : counts.classes;
        return Math.min(threads, ParallelComputerUtil.toNonNegative(count));
    }

    private static int minMethods(int threads, RunnerCounter counts) {
        long count = counts == null ? Integer.MAX_VALUE : counts.methods;
        return Math.min(threads, ParallelComputerUtil.toNonNegative(count));
    }

    private static int toNonNegative(long num) {
        return (int)Math.min(num > 0L ? num : 0L, Integer.MAX_VALUE);
    }

    private static int toNonNegative(double num) {
        return (int)Math.min(num > 0.0 ? num : 0.0, 2.147483647E9);
    }
}

