/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.util.internal.ByteBuffer;

public class LogicalStream {
    private final List<Entry> output = new ArrayList<Entry>();

    public synchronized void write(boolean stdout, byte[] b, int off, int len) {
        Entry entry = new Entry(stdout, b, off, len);
        if (!entry.isBlankLine()) {
            this.output.add(entry);
        }
    }

    public synchronized void writeDetails(ConsoleOutputReceiver outputReceiver) {
        for (Entry entry : this.output) {
            entry.writeDetails(outputReceiver);
        }
    }

    class Entry {
        final boolean stdout;
        final byte[] b;
        final int off;
        final int len;

        Entry(boolean stdout, byte[] b, int off, int len) {
            this.stdout = stdout;
            this.b = ByteBuffer.copy((byte[])b, (int)off, (int)len);
            this.off = 0;
            this.len = len;
        }

        public void writeDetails(ConsoleOutputReceiver outputReceiver) {
            outputReceiver.writeTestOutput(this.b, this.off, this.len, this.stdout);
        }

        public String toString() {
            return new String(this.b, this.off, this.len);
        }

        public boolean isBlankLine() {
            return "\n".equals(this.toString());
        }
    }
}

