/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.xml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.Os;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.xml.XMLEncode;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.xml.XMLWriter;

public class PrettyPrintXMLWriter
implements XMLWriter {
    private static final char[] CLOSE_1 = "/>".toCharArray();
    private static final char[] CLOSE_2 = "</".toCharArray();
    private static final char[] DEFAULT_LINE_INDENT = new char[]{' ', ' '};
    private PrintWriter writer;
    private ArrayList<String> elementStack = new ArrayList();
    private boolean processingElement = false;
    private boolean documentStarted = false;
    private boolean endOnSameLine = false;
    private int depth = 0;
    private char[] lineIndent;
    private char[] lineSeparator;
    private String encoding;
    private String docType;

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndent) {
        this(writer, lineIndent, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndent) {
        this(new PrintWriter(writer), lineIndent);
    }

    public PrettyPrintXMLWriter(PrintWriter writer) {
        this(writer, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndent, String encoding, String doctype) {
        this(writer, lineIndent.toCharArray(), Os.LINE_SEP.toCharArray(), encoding, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndent, String encoding, String doctype) {
        this(new PrintWriter(writer), lineIndent, encoding, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String encoding, String doctype) {
        this(writer, DEFAULT_LINE_INDENT, Os.LINE_SEP.toCharArray(), encoding, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer, String encoding, String doctype) {
        this(new PrintWriter(writer), encoding, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndent, String lineSeparator, String encoding, String doctype) {
        this(writer, lineIndent.toCharArray(), lineSeparator.toCharArray(), encoding, doctype);
    }

    private PrettyPrintXMLWriter(PrintWriter writer, char[] lineIndent, char[] lineSeparator, String encoding, String doctype) {
        this.writer = writer;
        this.lineIndent = lineIndent;
        this.lineSeparator = lineSeparator;
        this.encoding = encoding;
        this.docType = doctype;
        this.depth = 0;
    }

    @Override
    public void addAttribute(String key, String value) {
        if (!this.processingElement) {
            throw new IllegalStateException("currently processing no element");
        }
        this.writer.write(32);
        this.writer.write(key);
        this.writer.write(61);
        XMLEncode.xmlEncodeTextAsPCDATA(value, true, '\"', this.writer);
    }

    @Override
    public void setEncoding(String encoding) {
        if (this.documentStarted) {
            throw new IllegalStateException("Document headers already written!");
        }
        this.encoding = encoding;
    }

    @Override
    public void setDocType(String docType) {
        if (this.documentStarted) {
            throw new IllegalStateException("Document headers already written!");
        }
        this.docType = docType;
    }

    public void setLineSeparator(String lineSeparator) {
        if (this.documentStarted) {
            throw new IllegalStateException("Document headers already written!");
        }
        this.lineSeparator = lineSeparator.toCharArray();
    }

    public void setLineIndenter(String lineIndentParameter) {
        if (this.documentStarted) {
            throw new IllegalStateException("Document headers already written!");
        }
        this.lineIndent = lineIndentParameter.toCharArray();
    }

    @Override
    public void startElement(String elementName) {
        boolean firstLine = this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        if (!firstLine) {
            this.newLine();
        }
        this.writer.write(60);
        this.writer.write(elementName);
        this.processingElement = true;
        this.elementStack.add(this.depth++, elementName);
    }

    @Override
    public void writeText(String text) {
        this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        XMLEncode.xmlEncodeText(text, this.writer);
        this.endOnSameLine = true;
    }

    @Override
    public void writeMarkup(String markup) {
        this.ensureDocumentStarted();
        this.completePreviouslyOpenedElement();
        this.writer.write(markup);
    }

    @Override
    public void endElement() {
        String chars = this.elementStack.get(--this.depth);
        if (this.processingElement) {
            this.writer.write(CLOSE_1);
            this.processingElement = false;
        } else {
            if (!this.endOnSameLine) {
                this.newLine();
            }
            this.writer.write(CLOSE_2);
            this.writer.write(chars);
            this.writer.write(62);
        }
        this.endOnSameLine = false;
    }

    private boolean ensureDocumentStarted() {
        if (!this.documentStarted) {
            if (this.docType != null || this.encoding != null) {
                this.writeDocumentHeader();
            }
            this.documentStarted = true;
            return true;
        }
        return false;
    }

    private void writeDocumentHeader() {
        this.writer.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.writer.write(" encoding=\"");
            this.writer.write(this.encoding);
            this.writer.write(34);
        }
        this.writer.write("?>");
        this.newLine();
        if (this.docType != null) {
            this.newLine();
            this.writer.write("<!DOCTYPE ");
            this.writer.write(this.docType);
            this.writer.write(62);
        }
    }

    private void newLine() {
        this.writer.write(this.lineSeparator);
        for (int i = 0; i < this.depth; ++i) {
            this.writer.write(this.lineIndent);
        }
    }

    private void completePreviouslyOpenedElement() {
        if (this.processingElement) {
            this.writer.write(62);
            this.processingElement = false;
        }
    }
}

