/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.git.gitexe.command.AnonymousCommandLine;
import org.apache.maven.scm.provider.git.util.GitUtil;
import org.apache.maven.scm.providers.gitlib.settings.Settings;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public final class GitCommandLineUtils {
    private GitCommandLineUtils() {
    }

    public static void addTarget(Commandline cl, List<File> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        File workingDirectory = cl.getWorkingDirectory();
        try {
            String canonicalWorkingDirectory = workingDirectory.getCanonicalPath();
            for (File file : files) {
                String relativeFile = file.getPath();
                String canonicalFile = file.getCanonicalPath();
                if (canonicalFile.startsWith(canonicalWorkingDirectory) && (relativeFile = canonicalFile.substring(canonicalWorkingDirectory.length())).startsWith(File.separator)) {
                    relativeFile = relativeFile.substring(File.separator.length());
                }
                cl.createArg().setValue(FilenameUtils.separatorsToUnix((String)relativeFile));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not get canonical paths for workingDirectory = " + workingDirectory + " or files=" + files, ex);
        }
    }

    public static Commandline getBaseGitCommandLine(File workingDirectory, String command) {
        return GitCommandLineUtils.getAnonymousBaseGitCommandLine(workingDirectory, command);
    }

    private static Commandline getAnonymousBaseGitCommandLine(File workingDirectory, String command) {
        if (command == null || command.length() == 0) {
            return null;
        }
        AnonymousCommandLine cl = new AnonymousCommandLine();
        GitCommandLineUtils.composeCommand(workingDirectory, command, cl);
        return cl;
    }

    private static void composeCommand(File workingDirectory, String command, Commandline cl) {
        Settings settings = GitUtil.getSettings();
        cl.setExecutable(settings.getGitCommand());
        cl.createArg().setValue(command);
        if (workingDirectory != null) {
            cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        }
    }

    public static int execute(Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws ScmException {
        int exitCode;
        if (logger.isInfoEnabled()) {
            logger.info("Executing: " + cl);
            logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        return exitCode;
    }

    public static int execute(Commandline cl, CommandLineUtils.StringStreamConsumer stdout, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws ScmException {
        int exitCode;
        if (logger.isInfoEnabled()) {
            logger.info("Executing: " + cl);
            logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        return exitCode;
    }
}

