/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.war;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.war.AbstractWarMojo;
import org.apache.maven.plugins.war.util.ClassesPackager;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="war", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class WarMojo
extends AbstractWarMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String warName;
    @Parameter
    private String classifier;
    @Parameter
    private String packagingExcludes;
    @Parameter
    private String packagingIncludes;
    @Component(role=Archiver.class, hint="war")
    private WarArchiver warArchiver;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="true")
    private boolean primaryArtifact;
    @Parameter(defaultValue="false")
    private boolean attachClasses;
    @Parameter(defaultValue="classes")
    private String classesClassifier;
    @Parameter(property="maven.war.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping the execution.");
            return;
        }
        File warFile = this.getTargetWarFile();
        try {
            this.performPackaging(warFile);
        }
        catch (DependencyResolutionRequiredException | ArchiverException e) {
            throw new MojoExecutionException("Error assembling WAR: " + e.getMessage(), (Exception)e);
        }
        catch (IOException | ManifestException e) {
            throw new MojoExecutionException("Error assembling WAR", (Exception)e);
        }
    }

    private void performPackaging(File warFile) throws IOException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Packaging webapp");
        this.buildExplodedWebapp(this.getWebappDirectory());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setCreatedBy("Maven WAR Plugin", "org.apache.maven.plugins", "maven-war-plugin");
        archiver.setOutputFile(warFile);
        archiver.configureReproducible(this.outputTimestamp);
        this.getLog().debug((CharSequence)("Excluding " + Arrays.asList(this.getPackagingExcludes()) + " from the generated webapp archive."));
        this.getLog().debug((CharSequence)("Including " + Arrays.asList(this.getPackagingIncludes()) + " in the generated webapp archive."));
        this.warArchiver.addDirectory(this.getWebappDirectory(), this.getPackagingIncludes(), this.getPackagingExcludes());
        File webXmlFile = new File(this.getWebappDirectory(), "WEB-INF/web.xml");
        if (webXmlFile.exists()) {
            this.warArchiver.setWebxml(webXmlFile);
        }
        this.warArchiver.setRecompressAddedZips(this.isRecompressZippedFiles());
        this.warArchiver.setIncludeEmptyDirs(this.isIncludeEmptyDirectories());
        if (Boolean.FALSE.equals(this.failOnMissingWebXml) || this.failOnMissingWebXml == null && this.isProjectUsingAtLeastServlet30()) {
            this.getLog().debug((CharSequence)"Build won't fail if web.xml file is missing.");
            this.warArchiver.setExpectWebXml(false);
        }
        archiver.createArchive(this.getSession(), this.getProject(), this.getArchive());
        if (this.isAttachClasses()) {
            if (this.isArchiveClasses() && this.getJarArchiver().getDestFile() != null) {
                File targetClassesFile = this.getTargetClassesFile();
                FileUtils.copyFile((File)this.getJarArchiver().getDestFile(), (File)targetClassesFile);
                this.projectHelper.attachArtifact(this.getProject(), "jar", this.getClassesClassifier(), targetClassesFile);
            } else {
                ClassesPackager packager = new ClassesPackager();
                File classesDirectory = packager.getClassesDirectory(this.getWebappDirectory());
                if (classesDirectory.exists()) {
                    this.getLog().info((CharSequence)"Packaging classes");
                    packager.packageClasses(classesDirectory, this.getTargetClassesFile(), this.getJarArchiver(), this.getSession(), this.getProject(), this.getArchive(), this.outputTimestamp);
                    this.projectHelper.attachArtifact(this.getProject(), "jar", this.getClassesClassifier(), this.getTargetClassesFile());
                }
            }
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), "war", this.classifier, warFile);
        } else {
            Artifact artifact = this.getProject().getArtifact();
            if (this.primaryArtifact) {
                artifact.setFile(warFile);
            } else if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
                artifact.setFile(warFile);
            }
        }
    }

    private boolean isProjectUsingAtLeastServlet30() throws DependencyResolutionRequiredException, MalformedURLException {
        List classpathElements = this.getProject().getCompileClasspathElements();
        URL[] urls = new URL[classpathElements.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
        }
        URLClassLoader loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        return WarMojo.hasWebServletAnnotationClassInClasspath(loader);
    }

    private static boolean hasWebServletAnnotationClassInClasspath(ClassLoader loader) {
        return WarMojo.hasClassInClasspath(loader, "javax.servlet.annotation.WebServlet") || WarMojo.hasClassInClasspath(loader, "jakarta.servlet.annotation.WebServlet");
    }

    private static boolean hasClassInClasspath(ClassLoader loader, String clazz) {
        try {
            Class.forName(clazz, false, loader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected static File getTargetFile(File basedir, String finalName, String classifier, String type) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + "." + type);
    }

    protected File getTargetWarFile() {
        return WarMojo.getTargetFile(new File(this.getOutputDirectory()), this.getWarName(), this.getClassifier(), "war");
    }

    protected File getTargetClassesFile() {
        return WarMojo.getTargetFile(new File(this.getOutputDirectory()), this.getWarName(), this.getClassesClassifier(), "jar");
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String[] getPackagingExcludes() {
        if (StringUtils.isEmpty((String)this.packagingExcludes)) {
            return new String[0];
        }
        return StringUtils.split((String)this.packagingExcludes, (String)",");
    }

    public void setPackagingExcludes(String packagingExcludes) {
        this.packagingExcludes = packagingExcludes;
    }

    public String[] getPackagingIncludes() {
        if (StringUtils.isEmpty((String)this.packagingIncludes)) {
            return new String[]{"**"};
        }
        return StringUtils.split((String)this.packagingIncludes, (String)",");
    }

    public void setPackagingIncludes(String packagingIncludes) {
        this.packagingIncludes = packagingIncludes;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getWarName() {
        return this.warName;
    }

    public void setWarName(String warName) {
        this.warName = warName;
    }

    public WarArchiver getWarArchiver() {
        return this.warArchiver;
    }

    public void setWarArchiver(WarArchiver warArchiver) {
        this.warArchiver = warArchiver;
    }

    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public boolean isPrimaryArtifact() {
        return this.primaryArtifact;
    }

    public void setPrimaryArtifact(boolean primaryArtifact) {
        this.primaryArtifact = primaryArtifact;
    }

    public boolean isAttachClasses() {
        return this.attachClasses;
    }

    public void setAttachClasses(boolean attachClasses) {
        this.attachClasses = attachClasses;
    }

    public String getClassesClassifier() {
        return this.classesClassifier;
    }

    public void setClassesClassifier(String classesClassifier) {
        this.classesClassifier = classesClassifier;
    }

    public boolean isFailOnMissingWebXml() {
        return this.failOnMissingWebXml;
    }

    public void setFailOnMissingWebXml(boolean failOnMissingWebXml) {
        this.failOnMissingWebXml = failOnMissingWebXml;
    }

    public boolean isSkip() {
        return this.skip;
    }
}

