/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc.resolver;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceResolverConfig {
    private final MavenProject project;
    private ArtifactFilter filter;
    private List<MavenProject> reactorProjects;
    private final File outputBasedir;
    private boolean compileSourceIncluded;
    private boolean testSourceIncluded;
    private final ArtifactRepository localRepository;
    private final ArtifactResolver artifactResolver;
    private final ArtifactMetadataSource artifactMetadataSource;
    private final ArchiverManager archiverManager;
    private final ArtifactFactory artifactFactory;
    private final Log log;

    public SourceResolverConfig(Log log, MavenProject project, ArtifactRepository localRepository, File outputBasedir, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, ArtifactMetadataSource artifactMetadataSource, ArchiverManager archiverManager) {
        this.log = log;
        this.project = project;
        this.localRepository = localRepository;
        this.outputBasedir = outputBasedir;
        this.artifactResolver = artifactResolver;
        this.artifactFactory = artifactFactory;
        this.artifactMetadataSource = artifactMetadataSource;
        this.archiverManager = archiverManager;
    }

    public SourceResolverConfig withFilter(ArtifactFilter filter) {
        this.filter = filter;
        return this;
    }

    public SourceResolverConfig withReactorProjects(List<MavenProject> reactorProjects) {
        this.reactorProjects = reactorProjects;
        return this;
    }

    public SourceResolverConfig withCompileSources() {
        this.compileSourceIncluded = true;
        return this;
    }

    public SourceResolverConfig withoutCompileSources() {
        this.compileSourceIncluded = false;
        return this;
    }

    public SourceResolverConfig withTestSources() {
        this.testSourceIncluded = true;
        return this;
    }

    public SourceResolverConfig withoutTestSources() {
        this.testSourceIncluded = false;
        return this;
    }

    public MavenProject project() {
        return this.project;
    }

    public ArtifactRepository localRepository() {
        return this.localRepository;
    }

    public ArtifactFilter filter() {
        return this.filter;
    }

    public List<MavenProject> reactorProjects() {
        return this.reactorProjects;
    }

    public File outputBasedir() {
        return this.outputBasedir;
    }

    public boolean includeCompileSources() {
        return this.compileSourceIncluded;
    }

    public boolean includeTestSources() {
        return this.testSourceIncluded;
    }

    public ArtifactResolver artifactResolver() {
        return this.artifactResolver;
    }

    public ArtifactMetadataSource artifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public ArchiverManager archiverManager() {
        return this.archiverManager;
    }

    public ArtifactFactory artifactFactory() {
        return this.artifactFactory;
    }

    public Log log() {
        return this.log;
    }
}

