/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.mojos;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAssemblyMojo
extends AbstractMojo
implements AssemblerConfigurationSource {
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="assembly.escapeString")
    private String escapeString;
    @Parameter(property="assembly.skipAssembly", defaultValue="false")
    private boolean skipAssembly;
    @Parameter(property="assembly.dryRun", defaultValue="false")
    private boolean dryRun;
    @Parameter(defaultValue="true")
    private boolean ignoreDirFormatExtensions;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}/assembly/work", required=true)
    private File workDirectory;
    @Parameter
    private List<String> formats;
    @Deprecated
    @Parameter(property="classifier")
    private String classifier;
    @Parameter
    private String[] descriptors;
    @Parameter
    private String[] descriptorRefs;
    @Parameter
    private File descriptorSourceDirectory;
    @Parameter
    private File archiveBaseDirectory;
    @Deprecated
    @Parameter(property="descriptorId")
    private String descriptorId;
    @Deprecated
    @Parameter(property="descriptor")
    private String descriptor;
    @Parameter(property="assembly.tarLongFileMode", defaultValue="warn")
    private String tarLongFileMode;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    private File basedir;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private MavenReaderFilter mavenReaderFilter;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(defaultValue="${project.build.directory}/archive-tmp", required=true, readonly=true)
    private File tempRoot;
    @Parameter(defaultValue="${project.reporting.outputDirectory}", readonly=true)
    private File siteDirectory;
    @Deprecated
    @Parameter(property="includeSite", defaultValue="false")
    private boolean includeSite;
    @Parameter(property="assembly.appendAssemblyId", defaultValue="true")
    boolean appendAssemblyId;
    @Parameter(property="assembly.ignoreMissingDescriptor", defaultValue="false")
    private boolean ignoreMissingDescriptor;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter
    private List<String> filters;
    @Parameter(property="assembly.includeProjectBuildFilters", defaultValue="true")
    private boolean includeProjectBuildFilters;
    @Parameter(property="assembly.attach", defaultValue="true")
    private boolean attach;
    @Parameter(defaultValue="true")
    private boolean recompressZippedFiles;
    @Component
    private AssemblyArchiver assemblyArchiver;
    @Component
    private AssemblyReader assemblyReader;
    @Parameter
    private PlexusConfiguration archiverConfig;
    @Parameter(property="assembly.runOnlyAtExecutionRoot", defaultValue="false")
    private boolean runOnlyAtExecutionRoot;
    @Parameter(property="assembly.updateOnly", defaultValue="false")
    private boolean updateOnly;
    @Parameter(property="assembly.useJvmChmod", defaultValue="false")
    private boolean useJvmChmod;
    @Parameter(property="assembly.ignorePermissions", defaultValue="false")
    private boolean ignorePermissions;
    @Parameter
    private List<String> delimiters;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Assembly> assemblies;
        if (this.skipAssembly) {
            this.getLog().info((CharSequence)"Assemblies have been skipped per configuration of the skipAssembly parameter.");
            return;
        }
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the assembly in this project because it's not the Execution Root");
            return;
        }
        try {
            assemblies = this.assemblyReader.readAssemblies(this);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assemblies: " + e.getMessage(), (Exception)e);
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoFailureException((Object)this.assemblyReader, e.getMessage(), "Mojo configuration is invalid: " + e.getMessage());
        }
        boolean warnedAboutMainProjectArtifact = false;
        for (Assembly assembly : assemblies) {
            try {
                String fullName = AssemblyFormatUtils.getDistributionName(assembly, this);
                List<String> effectiveFormats = this.formats;
                if (effectiveFormats == null || effectiveFormats.size() == 0) {
                    effectiveFormats = assembly.getFormats();
                }
                if (effectiveFormats == null || effectiveFormats.size() == 0) {
                    throw new MojoFailureException("No formats specified in the execution parameters or the assembly descriptor.");
                }
                for (String format : effectiveFormats) {
                    File destFile = this.assemblyArchiver.createArchive(assembly, fullName, format, this, this.isRecompressZippedFiles());
                    MavenProject project = this.getProject();
                    String classifier = this.getClassifier();
                    String type = project.getArtifact().getType();
                    if (this.attach && destFile.isFile()) {
                        if (this.isAssemblyIdAppended()) {
                            this.projectHelper.attachArtifact(project, format, assembly.getId(), destFile);
                            continue;
                        }
                        if (classifier != null) {
                            this.projectHelper.attachArtifact(project, format, classifier, destFile);
                            continue;
                        }
                        if (!"pom".equals(type) && format.equals(type)) {
                            File existingFile;
                            if (!warnedAboutMainProjectArtifact) {
                                StringBuilder message = new StringBuilder();
                                message.append("Configuration options: 'appendAssemblyId' is set to false, and 'classifier' is missing.");
                                message.append("\nInstead of attaching the assembly file: ").append(destFile).append(", it will become the file for main project artifact.");
                                message.append("\nNOTE: If multiple descriptors or descriptor-formats are provided for this project, the value of this file will be non-deterministic!");
                                this.getLog().warn((CharSequence)message);
                                warnedAboutMainProjectArtifact = true;
                            }
                            if ((existingFile = project.getArtifact().getFile()) != null && existingFile.exists()) {
                                this.getLog().warn((CharSequence)("Replacing pre-existing project main-artifact file: " + existingFile + "\nwith assembly file: " + destFile));
                            }
                            project.getArtifact().setFile(destFile);
                            continue;
                        }
                        this.projectHelper.attachArtifact(project, format, null, destFile);
                        continue;
                    }
                    if (!this.attach) continue;
                    this.getLog().warn((CharSequence)("Assembly file: " + destFile + " is not a regular file (it may be a directory). It cannot be attached to the project build for installation or deployment."));
                }
            }
            catch (ArchiveCreationException e) {
                throw new MojoExecutionException("Failed to create assembly: " + e.getMessage(), (Exception)e);
            }
            catch (AssemblyFormattingException e) {
                throw new MojoExecutionException("Failed to create assembly: " + e.getMessage(), (Exception)e);
            }
            catch (InvalidAssemblerConfigurationException e) {
                throw new MojoFailureException((Object)assembly, "Assembly is incorrectly configured: " + assembly.getId(), "Assembly: " + assembly.getId() + " is not configured correctly: " + e.getMessage());
            }
        }
    }

    boolean isThisTheExecutionRoot() {
        Log log = this.getLog();
        log.debug((CharSequence)("Root Folder:" + this.mavenSession.getExecutionRootDirectory()));
        log.debug((CharSequence)("Current Folder:" + this.basedir));
        boolean result = this.mavenSession.getExecutionRootDirectory().equalsIgnoreCase(this.basedir.toString());
        if (result) {
            log.debug((CharSequence)"This is the execution root.");
        } else {
            log.debug((CharSequence)"This is NOT the execution root.");
        }
        return result;
    }

    AssemblyArchiver getAssemblyArchiver() {
        return this.assemblyArchiver;
    }

    AssemblyReader getAssemblyReader() {
        return this.assemblyReader;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    @Override
    @Deprecated
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    @Deprecated
    public String getDescriptorId() {
        return this.descriptorId;
    }

    @Override
    public String[] getDescriptorReferences() {
        return this.descriptorRefs;
    }

    @Override
    public File getDescriptorSourceDirectory() {
        return this.descriptorSourceDirectory;
    }

    @Override
    public String[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public abstract MavenProject getProject();

    @Override
    public File getSiteDirectory() {
        return this.siteDirectory;
    }

    @Override
    public boolean isSiteIncluded() {
        return this.includeSite;
    }

    @Override
    public String getFinalName() {
        return this.finalName;
    }

    @Override
    public boolean isAssemblyIdAppended() {
        return this.appendAssemblyId;
    }

    @Override
    public String getTarLongFileMode() {
        return this.tarLongFileMode;
    }

    @Override
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public MavenArchiveConfiguration getJarArchiveConfiguration() {
        return this.archive;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workDirectory;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public File getTemporaryRootDirectory() {
        return this.tempRoot;
    }

    @Override
    public File getArchiveBaseDirectory() {
        return this.archiveBaseDirectory;
    }

    @Override
    public List<String> getFilters() {
        if (this.filters == null) {
            this.filters = this.getProject().getBuild().getFilters();
            if (this.filters == null) {
                this.filters = Collections.emptyList();
            }
        }
        return this.filters;
    }

    @Override
    public boolean isIncludeProjectBuildFilters() {
        return this.includeProjectBuildFilters;
    }

    @Override
    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    @Override
    public String getClassifier() {
        return null;
    }

    protected MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    public void setAppendAssemblyId(boolean appendAssemblyId) {
        this.appendAssemblyId = appendAssemblyId;
    }

    public void setArchive(MavenArchiveConfiguration archive) {
        this.archive = archive;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Deprecated
    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    @Deprecated
    public void setDescriptorId(String descriptorId) {
        this.descriptorId = descriptorId;
    }

    public void setDescriptorRefs(String[] descriptorRefs) {
        this.descriptorRefs = descriptorRefs;
    }

    public void setDescriptors(String[] descriptors) {
        this.descriptors = descriptors;
    }

    public void setDescriptorSourceDirectory(File descriptorSourceDirectory) {
        this.descriptorSourceDirectory = descriptorSourceDirectory;
    }

    public void setFilters(List<String> filters) {
        this.filters = filters;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public void setIncludeSite(boolean includeSite) {
        this.includeSite = includeSite;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setProjectHelper(MavenProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    public void setReactorProjects(List<MavenProject> reactorProjects) {
        this.reactorProjects = reactorProjects;
    }

    public void setSiteDirectory(File siteDirectory) {
        this.siteDirectory = siteDirectory;
    }

    public void setTarLongFileMode(String tarLongFileMode) {
        this.tarLongFileMode = tarLongFileMode;
    }

    public void setTempRoot(File tempRoot) {
        this.tempRoot = tempRoot;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public boolean isIgnoreDirFormatExtensions() {
        return this.ignoreDirFormatExtensions;
    }

    @Override
    public boolean isIgnoreMissingDescriptor() {
        return this.ignoreMissingDescriptor;
    }

    public void setIgnoreMissingDescriptor(boolean ignoreMissingDescriptor) {
        this.ignoreMissingDescriptor = ignoreMissingDescriptor;
    }

    @Override
    public MavenSession getMavenSession() {
        return this.mavenSession;
    }

    @Override
    public String getArchiverConfig() {
        return this.archiverConfig == null ? null : this.archiverConfig.toString();
    }

    @Override
    public MavenReaderFilter getMavenReaderFilter() {
        return this.mavenReaderFilter;
    }

    @Override
    public boolean isUpdateOnly() {
        return this.updateOnly;
    }

    @Override
    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    @Override
    public boolean isIgnorePermissions() {
        return this.ignorePermissions;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    boolean isRecompressZippedFiles() {
        return this.recompressZippedFiles;
    }

    @Override
    public String getEscapeString() {
        return this.escapeString;
    }

    @Override
    public List<String> getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(List<String> delimiters) {
        this.delimiters = delimiters;
    }
}

