/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive.task;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugin.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchivedFileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultArchivedFileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddArtifactTask {
    public static final String[] DEFAULT_INCLUDES_ARRAY = new String[]{"**/*"};
    private int directoryMode = -1;
    private int fileMode = -1;
    private boolean unpack = false;
    private List<String> includes;
    private List<String> excludes;
    private final Artifact artifact;
    private MavenProject project;
    private MavenProject moduleProject;
    private Artifact moduleArtifact;
    private String outputDirectory;
    private String outputFileNameMapping;
    private final Logger logger;
    private final InputStreamTransformer transformer;

    public AddArtifactTask(Artifact artifact, Logger logger, InputStreamTransformer transformer) {
        this.artifact = artifact;
        this.logger = logger;
        this.transformer = transformer;
    }

    public AddArtifactTask(Artifact artifact, Logger logger) {
        this(artifact, logger, null);
    }

    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException {
        if (this.artifactIsArchiverDestination(archiver)) {
            this.artifact.setFile(this.moveArtifactSomewhereElse(configSource));
        }
        String destDirectory = AssemblyFormatUtils.getOutputDirectory(this.outputDirectory, configSource.getProject(), this.moduleProject, this.project, configSource.getFinalName(), configSource);
        if (this.unpack) {
            Object[] includesArray;
            String outputLocation = destDirectory;
            if (outputLocation.length() > 0 && !outputLocation.endsWith("/")) {
                outputLocation = outputLocation + "/";
            }
            if ((includesArray = TypeConversionUtils.toStringArray(this.includes)) == null) {
                includesArray = DEFAULT_INCLUDES_ARRAY;
            }
            Object[] excludesArray = TypeConversionUtils.toStringArray(this.excludes);
            int oldDirMode = archiver.getOverrideDirectoryMode();
            int oldFileMode = archiver.getOverrideFileMode();
            boolean fileModeSet = false;
            boolean dirModeSet = false;
            try {
                File artifactFile;
                if (this.fileMode != -1) {
                    archiver.setFileMode(this.fileMode);
                    fileModeSet = true;
                }
                if (this.directoryMode != -1) {
                    archiver.setDirectoryMode(this.directoryMode);
                    dirModeSet = true;
                }
                if ((artifactFile = this.artifact.getFile()) == null) {
                    this.logger.warn("Skipping artifact: " + this.artifact.getId() + "; it does not have an associated file or directory.");
                }
                if (artifactFile.isDirectory()) {
                    this.logger.debug("Adding artifact directory contents for: " + this.artifact + " to: " + outputLocation);
                    DefaultFileSet fs = DefaultFileSet.fileSet((File)artifactFile);
                    fs.setIncludes((String[])includesArray);
                    fs.setExcludes((String[])excludesArray);
                    fs.setPrefix(outputLocation);
                    fs.setStreamTransformer(this.transformer);
                    archiver.addFileSet((FileSet)fs);
                }
                this.logger.debug("Unpacking artifact contents for: " + this.artifact + " to: " + outputLocation);
                this.logger.debug("includes:\n" + StringUtils.join((Object[])includesArray, (String)"\n") + "\n");
                this.logger.debug("excludes:\n" + (excludesArray == null ? "none" : StringUtils.join((Object[])excludesArray, (String)"\n")) + "\n");
                DefaultArchivedFileSet afs = DefaultArchivedFileSet.archivedFileSet((File)artifactFile);
                afs.setIncludes((String[])includesArray);
                afs.setExcludes((String[])excludesArray);
                afs.setPrefix(outputLocation);
                afs.setStreamTransformer(this.transformer);
                archiver.addArchivedFileSet((ArchivedFileSet)afs);
            }
            catch (ArchiverException e) {
                throw new ArchiveCreationException("Error adding file-set for '" + this.artifact.getId() + "' to archive: " + e.getMessage(), e);
            }
            finally {
                if (dirModeSet) {
                    archiver.setDirectoryMode(oldDirMode);
                }
                if (fileModeSet) {
                    archiver.setFileMode(oldFileMode);
                }
            }
        } else {
            String tempMapping = AssemblyFormatUtils.evaluateFileNameMapping(this.outputFileNameMapping, this.artifact, configSource.getProject(), this.moduleProject, this.moduleArtifact, this.project, configSource);
            String outputLocation = destDirectory + tempMapping;
            try {
                File artifactFile = this.artifact.getFile();
                this.logger.debug("Adding artifact: " + this.artifact.getId() + " with file: " + artifactFile + " to assembly location: " + outputLocation + ".");
                if (this.fileMode != -1) {
                    archiver.addFile(artifactFile, outputLocation, this.fileMode);
                } else {
                    archiver.addFile(artifactFile, outputLocation);
                }
            }
            catch (ArchiverException e) {
                throw new ArchiveCreationException("Error adding file '" + this.artifact.getId() + "' to archive: " + e.getMessage(), e);
            }
        }
    }

    private File moveArtifactSomewhereElse(AssemblerConfigurationSource configSource) throws ArchiveCreationException {
        File tempRoot = configSource.getTemporaryRootDirectory();
        File tempArtifactFile = new File(tempRoot, this.artifact.getFile().getName());
        this.logger.warn("Artifact: " + this.artifact.getId() + " references the same file as the assembly destination file. Moving it to a temporary location for inclusion.");
        try {
            FileUtils.copyFile((File)this.artifact.getFile(), (File)tempArtifactFile);
        }
        catch (IOException e) {
            throw new ArchiveCreationException("Error moving artifact file: '" + this.artifact.getFile() + "' to temporary location: " + tempArtifactFile + ". Reason: " + e.getMessage(), e);
        }
        return tempArtifactFile;
    }

    private boolean artifactIsArchiverDestination(Archiver archiver) {
        return this.artifact.getFile() != null && archiver.getDestFile() != null && this.artifact.getFile().equals(archiver.getDestFile());
    }

    public void setDirectoryMode(int directoryMode) {
        this.directoryMode = directoryMode;
    }

    public void setFileMode(int fileMode) {
        this.fileMode = fileMode;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setFileNameMapping(String outputFileNameMapping) {
        this.outputFileNameMapping = outputFileNameMapping;
    }

    public void setOutputDirectory(String outputDirectory, String defaultOutputDirectory) {
        this.setOutputDirectory(outputDirectory == null ? defaultOutputDirectory : outputDirectory);
    }

    public void setFileNameMapping(String outputFileNameMapping, String defaultOutputFileNameMapping) {
        this.setFileNameMapping(outputFileNameMapping == null ? defaultOutputFileNameMapping : outputFileNameMapping);
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }
}

