/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import java.net.URLStreamHandler;
import java.util.Collection;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.http.HttpFileSystem;
import org.apache.commons.vfs2.provider.webdav.WebdavFileObject;
import org.apache.commons.vfs2.provider.webdav.WebdavFileProvider;

public class WebdavFileSystem
extends HttpFileSystem {
    protected WebdavFileSystem(GenericFileName rootName, HttpClient client, FileSystemOptions fileSystemOptions) {
        super(rootName, client, fileSystemOptions);
    }

    @Override
    protected HttpClient getClient() {
        return super.getClient();
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(WebdavFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) {
        return new WebdavFileObject(name, this);
    }

    public URLStreamHandler getURLStreamHandler() {
        return new DefaultURLStreamHandler(this.getContext(), this.getFileSystemOptions());
    }
}

