/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonType
implements VariableType {
    private static final Logger logger = LoggerFactory.getLogger(JsonType.class);
    protected final int maxLength;
    protected ObjectMapper objectMapper;
    protected boolean serializePOJOsInVariablesToJson;
    protected String javaClassFieldForJackson;

    public JsonType(int maxLength, ObjectMapper objectMapper, boolean serializePOJOsInVariablesToJson, String javaClassFieldForJackson) {
        this.maxLength = maxLength;
        this.objectMapper = objectMapper;
        this.serializePOJOsInVariablesToJson = serializePOJOsInVariablesToJson;
        this.javaClassFieldForJackson = javaClassFieldForJackson;
    }

    @Override
    public String getTypeName() {
        return "json";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        Object jsonValue = null;
        if (valueFields.getTextValue() != null && valueFields.getTextValue().length() > 0) {
            JsonNode classNode;
            if (jsonValue == null) {
                try {
                    jsonValue = this.objectMapper.readTree(valueFields.getTextValue());
                }
                catch (Exception e) {
                    logger.error("Error reading json variable " + valueFields.getName(), (Throwable)e);
                }
            }
            if (jsonValue != null && StringUtils.isNotBlank((CharSequence)this.javaClassFieldForJackson) && (classNode = jsonValue.get(this.javaClassFieldForJackson)) != null) {
                String type = classNode.asText();
                Class<?> cls = null;
                try {
                    cls = Class.forName(type, false, this.getClass().getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Unable to obtain type for json variable object " + valueFields.getName(), (Throwable)e);
                }
                if (cls != null) {
                    jsonValue = this.objectMapper.convertValue(jsonValue, cls);
                }
            }
        }
        return jsonValue;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        try {
            valueFields.setTextValue(this.objectMapper.writeValueAsString(value));
        }
        catch (JsonProcessingException e) {
            logger.error("Error writing json variable " + valueFields.getName(), (Throwable)e);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (JsonNode.class.isAssignableFrom(value.getClass()) || this.objectMapper.canSerialize(value.getClass()) && this.serializePOJOsInVariablesToJson) {
            try {
                return this.objectMapper.writeValueAsString(value).length() <= this.maxLength;
            }
            catch (JsonProcessingException e) {
                logger.error("Error writing json variable of type " + value.getClass(), (Throwable)e);
            }
        }
        return false;
    }
}

