/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.Error;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.apache.commons.lang3.StringUtils;

public class ErrorPropagation {
    public static void propagateError(BpmnError error, DelegateExecution execution) {
        ErrorPropagation.propagateError(error.getErrorCode(), execution);
    }

    public static void propagateError(String errorRef, DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager;
        ExecutionEntity processInstanceExecution;
        Map<String, List<Event>> eventMap = ErrorPropagation.findCatchingEventsForProcess(execution.getProcessDefinitionId(), errorRef);
        if (eventMap.size() > 0) {
            ErrorPropagation.executeCatch(eventMap, execution, errorRef);
        } else if (!execution.getProcessInstanceId().equals(execution.getRootProcessInstanceId()) && (processInstanceExecution = (ExecutionEntity)(executionEntityManager = Context.getCommandContext().getExecutionEntityManager()).findById(execution.getProcessInstanceId())) != null) {
            ExecutionEntity parentExecution = processInstanceExecution.getSuperExecution();
            HashSet<String> toDeleteProcessInstanceIds = new HashSet<String>();
            toDeleteProcessInstanceIds.add(execution.getProcessInstanceId());
            while (parentExecution != null && eventMap.size() == 0) {
                eventMap = ErrorPropagation.findCatchingEventsForProcess(parentExecution.getProcessDefinitionId(), errorRef);
                if (eventMap.size() > 0) {
                    for (String processInstanceId : toDeleteProcessInstanceIds) {
                        ExecutionEntity processInstanceEntity = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
                        executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceEntity.getId(), execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : null, "ERROR_EVENT " + errorRef, false, false);
                        if (Context.getProcessEngineConfiguration() == null || !Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
                        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, processInstanceEntity));
                    }
                    ErrorPropagation.executeCatch(eventMap, parentExecution, errorRef);
                    continue;
                }
                toDeleteProcessInstanceIds.add(parentExecution.getProcessInstanceId());
                ExecutionEntity superExecution = parentExecution.getSuperExecution();
                if (superExecution != null) {
                    parentExecution = superExecution;
                    continue;
                }
                if (!parentExecution.getId().equals(parentExecution.getRootProcessInstanceId())) {
                    parentExecution = parentExecution.getProcessInstance();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (eventMap.size() == 0) {
            throw new BpmnError(errorRef, "No catching boundary event found for error with errorCode '" + errorRef + "', neither in same process nor in parent process");
        }
    }

    protected static void executeCatch(Map<String, List<Event>> eventMap, DelegateExecution delegateExecution, String errorId) {
        Event matchingEvent = null;
        ExecutionEntity currentExecution = (ExecutionEntity)delegateExecution;
        ExecutionEntity parentExecution = null;
        if (eventMap.containsKey(currentExecution.getActivityId())) {
            matchingEvent = eventMap.get(currentExecution.getActivityId()).get(0);
            parentExecution = currentExecution.getParentId() != null && currentExecution.getParent().isMultiInstanceRoot() ? currentExecution.getParent() : currentExecution;
        } else {
            parentExecution = currentExecution.getParent();
            while (matchingEvent == null && parentExecution != null) {
                FlowElementsContainer currentContainer = null;
                if (parentExecution.getCurrentFlowElement() instanceof FlowElementsContainer) {
                    currentContainer = (FlowElementsContainer)parentExecution.getCurrentFlowElement();
                } else if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                    currentContainer = ProcessDefinitionUtil.getProcess(parentExecution.getProcessDefinitionId());
                }
                for (String refId : eventMap.keySet()) {
                    List<Event> events = eventMap.get(refId);
                    if (!CollectionUtil.isNotEmpty(events) || !(events.get(0) instanceof StartEvent) || currentContainer.getFlowElement(refId) == null) continue;
                    matchingEvent = events.get(0);
                }
                if (matchingEvent != null) continue;
                if (eventMap.containsKey(parentExecution.getActivityId())) {
                    matchingEvent = eventMap.get(parentExecution.getActivityId()).get(0);
                    if (parentExecution.getParentId() == null || !parentExecution.getParent().isMultiInstanceRoot()) continue;
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)parentExecution.getParentId())) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (matchingEvent == null || parentExecution == null) {
            throw new ActivitiException("No matching parent execution for error code " + errorId + " found");
        }
        ErrorPropagation.executeEventHandler(matchingEvent, parentExecution, currentExecution, errorId);
    }

    protected static void executeEventHandler(Event event, ExecutionEntity parentExecution, ExecutionEntity currentExecution, String errorId) {
        BpmnModel bpmnModel;
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId())) != null) {
            String errorCode = Optional.ofNullable((Error)bpmnModel.getErrors().get(errorId)).map(Error::getErrorCode).orElse(errorId);
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createErrorEvent(ActivitiEventType.ACTIVITY_ERROR_RECEIVED, event.getId(), errorId, errorCode, parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId()));
        }
        if (event instanceof StartEvent) {
            ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
            if (!currentExecution.getParentId().equals(parentExecution.getId())) {
                Context.getAgenda().planDestroyScopeOperation(currentExecution);
            } else {
                executionEntityManager.deleteExecutionAndRelatedData(currentExecution, null, false);
            }
            ExecutionEntity eventSubProcessExecution = executionEntityManager.createChildExecution(parentExecution);
            eventSubProcessExecution.setCurrentFlowElement((FlowElement)event);
            Context.getAgenda().planContinueProcessOperation(eventSubProcessExecution);
        } else {
            ExecutionEntity boundaryExecution = null;
            List<? extends ExecutionEntity> childExecutions = parentExecution.getExecutions();
            for (ExecutionEntity executionEntity : childExecutions) {
                if (!executionEntity.getActivityId().equals(event.getId())) continue;
                boundaryExecution = executionEntity;
            }
            Context.getAgenda().planTriggerExecutionOperation(boundaryExecution);
        }
    }

    protected static Map<String, List<Event>> findCatchingEventsForProcess(String processDefinitionId, String errorRef) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        String compareErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorRef);
        List subProcesses = process.findFlowElementsOfType(EventSubProcess.class, true);
        for (EventSubProcess eventSubProcess : subProcesses) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                ErrorEventDefinition errorEventDef;
                String eventErrorCode;
                StartEvent startEvent;
                if (!(flowElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)startEvent.getEventDefinitions().get(0)).getErrorRef())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
                ArrayList<StartEvent> startEvents = new ArrayList<StartEvent>();
                startEvents.add(startEvent);
                eventMap.put(eventSubProcess.getId(), startEvents);
            }
        }
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            ErrorEventDefinition errorEventDef;
            String eventErrorCode;
            if (boundaryEvent.getAttachedToRefId() == null || !CollectionUtil.isNotEmpty(boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)boundaryEvent.getEventDefinitions().get(0)).getErrorRef())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
            List<BoundaryEvent> elementBoundaryEvents = null;
            if (!eventMap.containsKey(boundaryEvent.getAttachedToRefId())) {
                elementBoundaryEvents = new ArrayList();
                eventMap.put(boundaryEvent.getAttachedToRefId(), elementBoundaryEvents);
            } else {
                elementBoundaryEvents = (List)eventMap.get(boundaryEvent.getAttachedToRefId());
            }
            elementBoundaryEvents.add(boundaryEvent);
        }
        return eventMap;
    }

    public static boolean mapException(Exception e, ExecutionEntity execution, List<MapExceptionEntry> exceptionMap) {
        CallActivity callActivity;
        String errorCode = ErrorPropagation.findMatchingExceptionMapping(e, exceptionMap);
        if (errorCode != null) {
            ErrorPropagation.propagateError(errorCode, (DelegateExecution)execution);
            return true;
        }
        DelegateExecution callActivityExecution = null;
        ExecutionEntity parentExecution = execution.getParent();
        while (parentExecution != null && callActivityExecution == null) {
            if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                if (parentExecution.getSuperExecution() != null) {
                    callActivityExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
                continue;
            }
            parentExecution = parentExecution.getParent();
        }
        if (callActivityExecution != null && CollectionUtil.isNotEmpty((callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement()).getMapExceptions()) && (errorCode = ErrorPropagation.findMatchingExceptionMapping(e, callActivity.getMapExceptions())) != null) {
            ErrorPropagation.propagateError(errorCode, callActivityExecution);
            return true;
        }
        return false;
    }

    protected static String findMatchingExceptionMapping(Exception e, List<MapExceptionEntry> exceptionMap) {
        String defaultExceptionMapping = null;
        for (MapExceptionEntry me : exceptionMap) {
            Class<?> exceptionClassClass;
            String exceptionClass = me.getClassName();
            String errorCode = me.getErrorCode();
            if (StringUtils.isNotEmpty((CharSequence)errorCode) && StringUtils.isEmpty((CharSequence)exceptionClass) && defaultExceptionMapping == null) {
                defaultExceptionMapping = errorCode;
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)exceptionClass)) continue;
            if (e.getClass().getName().equals(exceptionClass)) {
                return errorCode;
            }
            if (!me.isAndChildren() || !(exceptionClassClass = ReflectUtil.loadClass(exceptionClass)).isAssignableFrom(e.getClass())) continue;
            return errorCode;
        }
        return defaultExceptionMapping;
    }

    protected static String retrieveErrorCode(BpmnModel bpmnModel, String errorRef) {
        return Optional.ofNullable(errorRef).map(ref -> {
            if (bpmnModel.containsErrorRef(errorRef)) {
                return Optional.ofNullable((Error)bpmnModel.getErrors().get(errorRef)).map(Error::getErrorCode).orElse(errorRef);
            }
            return errorRef;
        }).orElse(errorRef);
    }
}

