/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.io.ModbusASCIITransport;
import net.wimpi.modbus.io.ModbusBINTransport;
import net.wimpi.modbus.io.ModbusRTUTransport;
import net.wimpi.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.util.SerialParameters;

public class SerialConnection
implements SerialPortEventListener {
    private SerialParameters m_Parameters;
    private ModbusSerialTransport m_Transport;
    private CommPortIdentifier m_PortIdentifyer;
    private SerialPort m_SerialPort;
    private boolean m_Open;
    private InputStream m_SerialIn;

    public SerialConnection(SerialParameters parameters) {
        this.m_Parameters = parameters;
        this.m_Open = false;
    }

    public SerialPort getSerialPort() {
        return this.m_SerialPort;
    }

    public ModbusTransport getModbusTransport() {
        return this.m_Transport;
    }

    public void open() throws Exception {
        try {
            this.m_PortIdentifyer = CommPortIdentifier.getPortIdentifier((String)this.m_Parameters.getPortName());
        }
        catch (NoSuchPortException e) {
            if (Modbus.debug) {
                System.out.println(e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
        try {
            this.m_SerialPort = (SerialPort)this.m_PortIdentifyer.open("Modbus Serial Master", 30000);
        }
        catch (PortInUseException e) {
            if (Modbus.debug) {
                System.out.println(e.getMessage());
            }
            throw new Exception(e.getMessage());
        }
        try {
            this.setConnectionParameters();
        }
        catch (Exception e) {
            this.m_SerialPort.close();
            if (Modbus.debug) {
                System.out.println(e.getMessage());
            }
            throw e;
        }
        if ("ascii".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusASCIITransport();
        } else if ("rtu".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusRTUTransport();
            this.setReceiveTimeout(this.m_Parameters.getReceiveTimeout());
        } else if ("bin".equals(this.m_Parameters.getEncoding())) {
            this.m_Transport = new ModbusBINTransport();
        }
        this.m_Transport.setEcho(this.m_Parameters.isEcho());
        try {
            this.m_SerialIn = this.m_SerialPort.getInputStream();
            this.m_Transport.setCommPort((CommPort)this.m_SerialPort);
        }
        catch (IOException e) {
            this.m_SerialPort.close();
            if (Modbus.debug) {
                System.out.println(e.getMessage());
            }
            throw new Exception("Error opening i/o streams");
        }
        try {
            this.m_SerialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException e) {
            this.m_SerialPort.close();
            if (Modbus.debug) {
                System.out.println(e.getMessage());
            }
            throw new Exception("too many listeners added");
        }
        this.m_SerialPort.notifyOnBreakInterrupt(true);
        this.m_Open = true;
    }

    public void setReceiveTimeout(int ms) {
        block2: {
            try {
                this.m_SerialPort.enableReceiveTimeout(ms);
            }
            catch (UnsupportedCommOperationException e) {
                if (!Modbus.debug) break block2;
                System.out.println(e.getMessage());
            }
        }
    }

    public void setConnectionParameters() throws Exception {
        int oldBaudRate = this.m_SerialPort.getBaudRate();
        int oldDatabits = this.m_SerialPort.getDataBits();
        int oldStopbits = this.m_SerialPort.getStopBits();
        int oldParity = this.m_SerialPort.getParity();
        int oldFlowControl = this.m_SerialPort.getFlowControlMode();
        try {
            this.m_SerialPort.setSerialPortParams(this.m_Parameters.getBaudRate(), this.m_Parameters.getDatabits(), this.m_Parameters.getStopbits(), this.m_Parameters.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            this.m_Parameters.setBaudRate(oldBaudRate);
            this.m_Parameters.setDatabits(oldDatabits);
            this.m_Parameters.setStopbits(oldStopbits);
            this.m_Parameters.setParity(oldParity);
            if (Modbus.debug) {
                System.out.println(e.getMessage());
            }
            throw new Exception("Unsupported parameter");
        }
        try {
            this.m_SerialPort.setFlowControlMode(this.m_Parameters.getFlowControlIn() | this.m_Parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException e) {
            if (Modbus.debug) {
                System.out.println(e.getMessage());
            }
            throw new Exception("Unsupported flow control");
        }
    }

    public void close() {
        if (!this.m_Open) {
            return;
        }
        if (this.m_SerialPort != null) {
            try {
                this.m_Transport.close();
                this.m_SerialIn.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
            this.m_SerialPort.close();
        }
        this.m_Open = false;
    }

    public boolean isOpen() {
        return this.m_Open;
    }

    public void serialEvent(SerialPortEvent e) {
        switch (e.getEventType()) {
            case 1: {
                break;
            }
            case 10: {
                if (!Modbus.debug) break;
                System.out.println("Serial port break detected");
                break;
            }
            default: {
                if (!Modbus.debug) break;
                System.out.println("Serial port event: " + e.getEventType());
            }
        }
    }
}

