/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.internal;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.core.SchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class SpringLockConfigurationExtractor
implements LockConfigurationExtractor {
    private final TemporalAmount defaultLockAtMostFor;
    private final TemporalAmount defaultLockAtLeastFor;
    private final StringValueResolver embeddedValueResolver;
    private final Logger logger = LoggerFactory.getLogger(SpringLockConfigurationExtractor.class);

    public SpringLockConfigurationExtractor(TemporalAmount defaultLockAtMostFor, TemporalAmount defaultLockAtLeastFor, StringValueResolver embeddedValueResolver) {
        this.defaultLockAtMostFor = Objects.requireNonNull(defaultLockAtMostFor);
        this.defaultLockAtLeastFor = Objects.requireNonNull(defaultLockAtLeastFor);
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public Optional<LockConfiguration> getLockConfiguration(Runnable task) {
        if (task instanceof ScheduledMethodRunnable) {
            ScheduledMethodRunnable scheduledMethodRunnable = (ScheduledMethodRunnable)task;
            return this.getLockConfiguration(scheduledMethodRunnable.getTarget(), scheduledMethodRunnable.getMethod());
        }
        this.logger.debug("Unknown task type " + task);
        return Optional.empty();
    }

    public Optional<LockConfiguration> getLockConfiguration(Object target, Method method) {
        SchedulerLock annotation = this.findAnnotation(target, method);
        if (this.shouldLock(annotation)) {
            return Optional.of(this.getLockConfiguration(annotation));
        }
        return Optional.empty();
    }

    public LockConfiguration getLockConfiguration(SchedulerLock annotation) {
        Instant now = Instant.now();
        return new LockConfiguration(this.getName(annotation), now.plus(this.getLockAtMostFor(annotation)), now.plus(this.getLockAtLeastFor(annotation)));
    }

    private String getName(SchedulerLock annotation) {
        if (this.embeddedValueResolver != null) {
            return this.embeddedValueResolver.resolveStringValue(annotation.name());
        }
        return annotation.name();
    }

    TemporalAmount getLockAtMostFor(SchedulerLock annotation) {
        return this.getValue(annotation.lockAtMostFor(), annotation.lockAtMostForString(), this.defaultLockAtMostFor, "lockAtMostForString");
    }

    TemporalAmount getLockAtLeastFor(SchedulerLock annotation) {
        return this.getValue(annotation.lockAtLeastFor(), annotation.lockAtLeastForString(), this.defaultLockAtLeastFor, "lockAtLeastForString");
    }

    private TemporalAmount getValue(long valueFromAnnotation, String stringValueFromAnnotation, TemporalAmount defaultValue, String paramName) {
        if (valueFromAnnotation >= 0L) {
            return Duration.of(valueFromAnnotation, ChronoUnit.MILLIS);
        }
        if (StringUtils.hasText((String)stringValueFromAnnotation)) {
            if (this.embeddedValueResolver != null) {
                stringValueFromAnnotation = this.embeddedValueResolver.resolveStringValue(stringValueFromAnnotation);
            }
            try {
                return Duration.of(Long.valueOf(stringValueFromAnnotation), ChronoUnit.MILLIS);
            }
            catch (NumberFormatException nfe) {
                try {
                    return Duration.parse(stringValueFromAnnotation);
                }
                catch (DateTimeParseException e) {
                    throw new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot parse into long nor duration");
                }
            }
        }
        return defaultValue;
    }

    SchedulerLock findAnnotation(Object target, Method method) {
        SchedulerLock annotation = this.findAnnotation(method);
        if (annotation != null) {
            return annotation;
        }
        Class targetClass = AopUtils.getTargetClass((Object)target);
        if (targetClass != null && !target.getClass().equals(targetClass)) {
            try {
                Method methodOnTarget = targetClass.getMethod(method.getName(), method.getParameterTypes());
                return this.findAnnotation(methodOnTarget);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    SchedulerLock findAnnotation(Method method) {
        return (SchedulerLock)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, SchedulerLock.class);
    }

    private boolean shouldLock(SchedulerLock annotation) {
        return annotation != null;
    }
}

